/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import pregenerator.base.impl.SelectorScreen;
import pregenerator.base.impl.comp.PregenButton;

public class CycleButton<T>
extends PregenButton {
    CycleState<T> state;
    Consumer<CycleButton<T>> onChange;
    boolean selectScreen = false;
    int lastPress = -1;

    public CycleButton(int xPos, int yPos, int width, int height, List<T> values, T current, Function<T, Component> displayFunction, Consumer<CycleButton<T>> onChange) {
        this(xPos, yPos, width, height, new CycleState<T>(current, displayFunction, values), onChange);
    }

    public CycleButton(int xPos, int yPos, int width, int height, CycleState<T> state, Consumer<CycleButton<T>> onChange) {
        super(xPos, yPos, width, height, state.getCurrentText(), null);
        this.state = state;
        this.onChange = onChange;
        this.state.setOwner(this);
    }

    public CycleButton<T> withSelectScreen() {
        this.selectScreen = true;
        return this;
    }

    public CycleButton<T> setValues(List<T> newValues) {
        if (this.state.setValues(newValues)) {
            this.m_93666_(this.state.getCurrentText());
        }
        return this;
    }

    public CycleButton<T> selected(T value) {
        if (this.state.setValue(value)) {
            this.m_93666_(this.state.getCurrentText());
        }
        return this;
    }

    protected boolean m_7972_(int button) {
        if (button == 0 || button == 1) {
            this.lastPress = button;
            return true;
        }
        return false;
    }

    @Override
    public void m_5691_() {
        if (Screen.m_96637_()) {
            if (this.selectScreen) {
                Minecraft mc = Minecraft.m_91087_();
                SelectorScreen<Object> screen = new SelectorScreen<Object>(mc.f_91080_, this.state.values, this.state.value, this.state.displayFunction, T -> {
                    this.state.setValue(T);
                    this.m_93666_(this.state.getCurrentText());
                    if (this.onChange != null) {
                        this.onChange.accept(this);
                    }
                });
                mc.m_91152_(screen);
            } else {
                this.state.cycleBackwards();
                this.m_93666_(this.state.getCurrentText());
                if (this.onChange != null) {
                    this.onChange.accept(this);
                }
            }
        } else if (Screen.m_96638_() || this.lastPress == 1) {
            this.state.cycleBackwards();
            this.m_93666_(this.state.getCurrentText());
            if (this.onChange != null) {
                this.onChange.accept(this);
            }
        } else {
            this.state.cycle();
            this.m_93666_(this.state.getCurrentText());
            if (this.onChange != null) {
                this.onChange.accept(this);
            }
        }
        this.lastPress = 0;
    }

    public List<T> getValues() {
        return this.state.getValues();
    }

    public int getIndex() {
        return this.state.getIndex();
    }

    public T getValue() {
        return this.state.getValue();
    }

    public static class CycleState<T> {
        Function<T, Component> displayFunction;
        List<T> values;
        T value;
        CycleButton<T> owner;

        @SafeVarargs
        public CycleState(T value, Component name, T ... values) {
            this(value, (T T) -> name, Arrays.asList(values));
        }

        public CycleState(T value, Component name, List<T> values) {
            this(value, (T T) -> name, values);
        }

        @SafeVarargs
        public CycleState(T value, Function<T, Component> displayFunction, T ... values) {
            this(value, displayFunction, Arrays.asList(values));
        }

        public CycleState(T value, Function<T, Component> displayFunction, List<T> values) {
            this.displayFunction = displayFunction;
            this.values = values;
            this.value = value;
        }

        public Component getCurrentText() {
            return this.displayFunction.apply(this.value);
        }

        public Component getText(T value) {
            return this.displayFunction.apply(value);
        }

        public int getIndex() {
            return this.values.indexOf(this.value);
        }

        public List<T> getValues() {
            return this.values;
        }

        public T getValue() {
            return this.value;
        }

        public CycleState<T> setOwner(CycleButton<T> owner) {
            this.owner = owner;
            return this;
        }

        public CycleButton<T> getOwner() {
            return this.owner;
        }

        public boolean setValues(List<T> newValues) {
            this.values = newValues;
            if (!this.values.contains(this.value)) {
                return this.setValue(this.values.get(0));
            }
            if (this.owner != null) {
                this.owner.m_93666_(this.getCurrentText());
            }
            return false;
        }

        public boolean setValue(T value) {
            int index = this.values.indexOf(value);
            if (index != -1 && index != this.getIndex()) {
                this.value = this.values.get(index);
                return true;
            }
            return false;
        }

        public void updateText() {
            if (this.owner != null) {
                this.owner.m_93666_(this.getCurrentText());
            }
        }

        public void cycleBackwards() {
            int index = this.getIndex() - 1;
            this.value = this.values.get(index < 0 ? this.values.size() - 1 : index);
        }

        public void cycle() {
            this.value = this.values.get((this.getIndex() + 1) % this.values.size());
        }
    }
}

