/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.Align;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.utils.config.config.Config;
import pregenerator.common.utils.config.config.ConfigEntry;
import pregenerator.common.utils.config.config.ConfigHandler;
import pregenerator.common.utils.config.config.ConfigSection;
import pregenerator.common.utils.config.config.ConfigSettings;
import pregenerator.common.utils.config.config.MappedConfig;
import pregenerator.common.utils.config.gui.api.BackgroundTypes;
import pregenerator.common.utils.config.internal.PermissionRule;
import pregenerator.common.utils.config.internal.PregenOverlay;
import pregenerator.common.utils.config.internal.SpeedEntry;
import pregenerator.common.utils.plugins.IPlugin;

public class PregenConfig {
    public static final PregenConfig INSTANCE = new PregenConfig();
    ConfigHandler handler;
    public ConfigEntry.IntValue threadingRule;
    public ConfigEntry.IntValue playerLimit;
    public ConfigEntry.IntValue deletionTimeLimit;
    public ConfigEntry.BoolValue threadScheduler;
    public ConfigEntry.BoolValue autoRestart;
    public ConfigEntry.BoolValue disableDiskProtection;
    public ConfigEntry.BoolValue disableWatchDogOverride;
    public ConfigEntry.BoolValue disableMemoryLeakFix;
    public ConfigEntry.BoolValue advancedArguments;
    public ConfigEntry.BoolValue showDockerWarning;
    public ConfigEntry.BoolValue enableLoginWarning;
    public ConfigEntry.BoolValue enableMemoryProtector;
    public ConfigEntry.IntValue requiredFreeMemory;
    public ConfigEntry.IntValue poiLimit;
    public MappedConfig<UUID, PermissionRule> permissionRules;
    public ConfigEntry.ParsedArray<SpeedEntry> speedConfig;
    public MappedConfig<ResourceKey<Level>, SpeedEntry> mappedSpeedConfig;
    public ConfigEntry.EnumList<ChunkLogger> loggerOrder;
    public ConfigEntry.BoolValue forceServerTranslation;
    public PregenOverlay pregenOverlay = new PregenOverlay();
    public ConfigEntry.BoolValue previewInfo;
    public ConfigEntry.IntValue tooltipDelay;
    public ConfigEntry.EnumValue<BackgroundTypes> backgrounds;
    public ConfigEntry.BoolValue ingame_background;

    private PregenConfig() {
    }

    public void init() {
        Config config = new Config("base");
        this.handler = ChunkPregenerator.FILE_WATCHER.createConfig(config, ConfigSettings.withFolder("pregen"));
        ConfigSection common = config.add("common");
        ConfigSection commands = common.addSubSection("commands");
        this.advancedArguments = commands.addBool("advanced-commands", FMLEnvironment.dist.isClient(), "Defines if better command arguments should be used that support Autocompletion better.", "When enabled it requires the mod to be installed on the client too");
        ConfigSection gen = common.addSubSection("generator");
        this.threadingRule = gen.addInt("threading-rule", 3, "Defines how many dimensions can be generated based on how many threads the CPU has.", "This is done due to how many threads mc takes, on average 6-8 can be required", "0: 1 Dimension generator no matter the CPU threads", "1>=: 1 Dimension per 10 - (configValue*2) the CPU threads").setRange(0, 5);
        this.threadScheduler = gen.addBool("advanced-thread-scheduler", false, "Defines if the Terrain & Post processing step should be split from each other.", "This is done because Terrain gen is usually (not anymore) faster then Post Processing", "Allowing the CPU to do more work and less waiting.");
        this.playerLimit = gen.addInt("player-limit", -1, "Define if the pregenerator should be paused if the player amount is reached").setMin(-1);
        this.autoRestart = gen.addBool("auto-restart-tasks", false, "Defines if the Pregenerator should auto continue Tasks if the server restarts for any reason.", "This doesn't automatically restart the game");
        this.speedConfig = gen.addParsedArray("pregen-speeds", SpeedEntry.getDefaultValues(), SpeedEntry.getSerializer(), "This is a cache that stores last recorded pregen speeds.", "This is used to generate Estimate Predictions for ETA of how long a task should take.", "This isn't a config that sets how fast the pregenerator should run, but a config that keeps track of how fast they have been in the past", "Default values are 1 chunk a tick, because it is at the center of the possible ranges.");
        this.mappedSpeedConfig = this.speedConfig.createdMappedConfig(this.handler, SpeedEntry::getDimension, Function.identity());
        ConfigSection deletion = common.addSubSection("deleter");
        this.deletionTimeLimit = deletion.addInt("deletion-time", 10, "Defines how many Milliseconds per tic the Deletor has to do it's work.").setRange(1, 1000);
        ConfigSection tweaks = common.addSubSection("tweaks");
        this.enableLoginWarning = tweaks.addBool("enable-login-warning", true, "Enables that the Server Preview Text in the Multiplayer Screen gets a Warning that if a Pregenerator is running", "With a ETA Included so players who want to know how long it will take.", "Once the Pregenerator is done or this is disabled the Original Text will be restored!");
        this.disableDiskProtection = tweaks.addBool("disable-disk-protection", false, "Defines if a Small change that minecraft added to chunk writing should be not fixed.", "Said change simply ensures that everything is written in sync to disk.", "This may lead to less chunk corruption.", "Chunk Pregen disables this change due to how much more it strains the storage the data is written to.", "To the Point where damaging your hardware isn't out of the question", "1.12 and older ran without this small change and world corruption wasn't an issue to begin.", "Setting this to \"True\", will remove the disabling of the setting. Do it at your own risk");
        this.disableWatchDogOverride = tweaks.addBool("disable-watchdog-override", false, "Defines if the Watchdog override should be disabled", "Said override increases the to much lag time from 60 seconds to 10 minutes.", "While for vanilla it isn't nessesary for modded this still is.", "This reduces the amount of crashes due to worldgen lag and ensures that there is still a fail safe present");
        this.disableMemoryLeakFix = tweaks.addBool("disable-poi-memory-leak-fix", false, "Disables a Fix that prevents Minecraft from leaking Memory with the Points of Interest system", "This fix is incompatible with Lithium and Lithium Ports and can be fixed by disabling the \"ai.poi\" section in their Mixin Configs or by disabling this", "When this is disabled your Maximum Pregeneration Radius is a lot smaller due to the memory leaks. So if you plan larger scale pregenerations this fix shouldn't be disabled");
        this.poiLimit = tweaks.addInt("poi-limit", 100000, "During Pregeneration Points of Interest (poi) accumulate until you run out of memory", "Because minecraft never unloads them chunk pregen has to do that.", "This config decides how many of them it keeps alive so the game won't crash", "Keeping to little on can cause crashes because minecraft and chunk pregen fight over how many of them are alive", "So having a decent buffer, especially if players are online, is a good idea", "The default is set so it should cover 99% of the cases").setMin(50000);
        this.showDockerWarning = tweaks.addBool("show-docker-warning", true, "Defines if Chunk Pregen should throw warnings if it discovers a badly configured Docker Container that would lead to lag issues");
        this.enableMemoryProtector = tweaks.addBool("enable-memory-protector", true, "Defines if the Memory Protector should be enabled", "If your Game runs out of Ram during Pregen. Instead of causing World Corruption the Pregenerator then will instead save the game and Kill the Process", "Then when the game restarted it will continue with fresh free ram.", "This is not nessesary for every pregeneration, but if you do a large one that takes days and you have world corruption that is the last thing you want!");
        this.requiredFreeMemory = tweaks.addInt("required-free-memory", 384, "How low the free memory for 30 second should be before the trigger kicks in.").setMin(32);
        ConfigSection customization = common.addSubSection("customization");
        this.loggerOrder = customization.addEnumList("logger-order", ObjectArrayList.wrap((Object[])ChunkLogger.values()), ChunkLogger.class, new String[]{"Defines what is send in the chat Spam during the pregneration", "This entries can be removed/reordered/added as you wish"});
        this.permissionRules = customization.addParsedArray("player-permissions", new ObjectArrayList(), PermissionRule.createPermissions(), new String[]{"Defines the Permissions clients can use", "Chunk Pregen comes with certain features that access server information, and sometimes you don't want to give OP rights since that will give access to everything", "The permission system is ment to give controlled access to features"}).createdMappedConfig(this.handler, PermissionRule::getPlayer, Function.identity());
        this.forceServerTranslation = customization.addBool("force-server-translation", false, "Defines if translations should be done serverside.", "This can address problems if the mod isn't installed on the client side.", "While this shouldn't happen it is nice to have a backup option", "Translation support should work 100% fine in singleplayer or if the mod is installed on the client when in a multiplayer session");
        ConfigSection client = config.add("client");
        this.tooltipDelay = client.addInt("tooltip-delay", 200, "Defines the delay when the Tooltip in guis shows up, number is in milliseconds", "This doesn't apply to the config itself!").setMin(0);
        this.previewInfo = client.addBool("info-trigger", true);
        this.pregenOverlay.init(client.addSubSection("pregen-overlay"), true, Align.START, Align.START, 1.0);
        this.backgrounds = client.addEnum("custom-background", BackgroundTypes.PLANKS, BackgroundTypes.class, "Allows to pick for a Custom Background for Configs");
        this.ingame_background = client.addBool("ingame-background", false, "Allows to set if the background is always visible or only if you are not in a active world");
        this.handler.register();
        ChunkPregenerator.PLUGINS.init(config.add("Plugins"));
        ChunkPregenerator.PLUGINS.fireEvent(IPlugin::load);
    }

    public ConfigHandler getHandler() {
        return this.handler;
    }

    public void save() {
        this.handler.save();
    }

    public void storeSpeed(ResourceKey<Level> dimension, float data) {
        Object2ObjectLinkedOpenHashMap entries = new Object2ObjectLinkedOpenHashMap();
        for (SpeedEntry entry : (List)this.speedConfig.getValue()) {
            entries.put(entry.getDimension(), entry);
        }
        entries.put(dimension, new SpeedEntry(dimension, data));
        this.speedConfig.set((SpeedEntry)new ObjectArrayList(entries.values()));
        this.save();
    }
}

