/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.core.managers;

import com.hypherionmc.sdlink.core.config.SDLinkCompatConfig;
import com.hypherionmc.sdlink.core.config.SDLinkConfig;
import com.hypherionmc.sdlink.core.discord.BotController;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.Role;
import com.hypherionmc.sdlink.util.SDLinkUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public final class RoleManager {
    private static final Set<Role> verificationRoles = new HashSet<Role>();
    private static final Set<Role> deniedRoles = new HashSet<Role>();
    private static Role verifiedRole = null;
    private static Set<Role> luckPermsRoles = new HashSet<Role>();
    private static Set<Role> ftbRanksRoles = new HashSet<Role>();

    public static void loadRequiredRoles(AtomicInteger errCount, StringBuilder builder) {
        verificationRoles.clear();
        deniedRoles.clear();
        luckPermsRoles.clear();
        ftbRanksRoles.clear();
        verifiedRole = null;
        if (SDLinkConfig.INSTANCE.accessControl.enabled || SDLinkConfig.INSTANCE.accessControl.optionalVerification) {
            SDLinkConfig.INSTANCE.accessControl.requiredRoles.forEach(r -> {
                Role role = RoleManager.getRole(errCount, builder, "Access Control", r);
                if (role != null) {
                    verificationRoles.add(role);
                }
            });
            SDLinkConfig.INSTANCE.accessControl.deniedRoles.forEach(r -> {
                Role role = RoleManager.getRole(errCount, builder, "Access Control Deny", r);
                if (role != null) {
                    deniedRoles.add(role);
                }
            });
            if (!SDLinkUtils.isNullOrEmpty(SDLinkConfig.INSTANCE.accessControl.verifiedRole)) {
                verifiedRole = RoleManager.getRole(errCount, builder, "Verified Player", SDLinkConfig.INSTANCE.accessControl.verifiedRole);
            }
        }
        if (SDLinkCompatConfig.INSTANCE.common.ftbranks) {
            SDLinkCompatConfig.INSTANCE.ftbRanksCompat.syncs.forEach(s -> {
                Role role = RoleManager.getRole(errCount, builder, "FTB Ranks Sync", s.role);
                if (role != null) {
                    ftbRanksRoles.add(role);
                }
            });
        }
        if (SDLinkCompatConfig.INSTANCE.common.luckperms) {
            SDLinkCompatConfig.INSTANCE.luckpermsCompat.syncs.forEach(s -> {
                Role role = RoleManager.getRole(errCount, builder, "LuckPerms Sync", s.role);
                if (role != null) {
                    luckPermsRoles.add(role);
                }
            });
        }
    }

    private static Role getRole(AtomicInteger errCount, StringBuilder builder, String roleIdentifier, String roleID) {
        Optional<Role> role = BotController.INSTANCE.getJDA().getGuilds().get(0).getRoles().stream().filter(r -> r.getId().equalsIgnoreCase(roleID) || r.getName().equalsIgnoreCase(roleID)).findFirst();
        if (role.isPresent()) {
            return role.get();
        }
        errCount.incrementAndGet();
        builder.append(errCount.get()).append(") ").append("Missing ").append(roleIdentifier).append(". Role: ").append(roleID).append(" cannot be found in the server").append("\r\n");
        return null;
    }

    @Generated
    public static Set<Role> getVerificationRoles() {
        return verificationRoles;
    }

    @Generated
    public static Set<Role> getDeniedRoles() {
        return deniedRoles;
    }

    @Generated
    public static Role getVerifiedRole() {
        return verifiedRole;
    }

    @Generated
    public static Set<Role> getLuckPermsRoles() {
        return luckPermsRoles;
    }

    @Generated
    public static Set<Role> getFtbRanksRoles() {
        return ftbRanksRoles;
    }
}

