/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.api.messaging.discord;

import com.hypherionmc.sdlink.api.accounts.DiscordAuthor;
import com.hypherionmc.sdlink.api.accounts.DiscordUser;
import com.hypherionmc.sdlink.api.accounts.MinecraftAccount;
import com.hypherionmc.sdlink.api.messaging.MessageType;
import com.hypherionmc.sdlink.api.messaging.discord.DiscordMessage;
import com.hypherionmc.sdlink.core.config.SDLinkConfig;
import com.hypherionmc.sdlink.core.config.impl.MessageIgnoreConfig;
import java.util.regex.Pattern;

public final class DiscordMessageBuilder {
    private final MessageType messageType;
    private DiscordAuthor author;
    private String message;
    private Runnable afterSend;

    public DiscordMessageBuilder(MessageType messageType) {
        this.messageType = messageType;
    }

    public DiscordMessageBuilder author(DiscordAuthor author) {
        this.author = author;
        if (author.getUsername().equalsIgnoreCase("server")) {
            this.author = DiscordAuthor.SERVER;
        }
        if (SDLinkConfig.INSTANCE.chatConfig.useLinkedNames && this.author != DiscordAuthor.SERVER) {
            MinecraftAccount account = MinecraftAccount.of(author.getProfile());
            DiscordUser discordUser = account.getDiscordUser();
            if (account != null && discordUser != null) {
                this.author = DiscordAuthor.of(discordUser.getEffectiveName(), discordUser.getAvatarUrl(), author.getUsername(), false);
            }
        }
        return this;
    }

    public DiscordMessageBuilder message(String message) {
        if (this.messageType == MessageType.CHAT) {
            message = Pattern.compile("@+(here|everyone)").matcher(message).replaceAll("");
            if (!SDLinkConfig.INSTANCE.chatConfig.allowMentionsFromChat) {
                message = Pattern.compile("<(?!a?:[^:]+:\\d{17,19}>)[^>]*>").matcher(message).replaceAll("");
            }
        }
        if (SDLinkConfig.INSTANCE.ignoreConfig.enabled) {
            for (MessageIgnoreConfig.Ignore i : SDLinkConfig.INSTANCE.ignoreConfig.entries) {
                if (i.searchMode == MessageIgnoreConfig.FilterMode.MATCHES && message.equalsIgnoreCase(i.search)) {
                    message = i.action == MessageIgnoreConfig.ActionMode.REPLACE ? message.replace(i.search, i.replace) : "";
                }
                if (i.searchMode == MessageIgnoreConfig.FilterMode.CONTAINS && message.contains(i.search)) {
                    message = i.action == MessageIgnoreConfig.ActionMode.REPLACE ? message.replace(i.search, i.replace) : "";
                }
                if (i.searchMode != MessageIgnoreConfig.FilterMode.STARTS_WITH || !message.startsWith(i.search)) continue;
                if (i.action == MessageIgnoreConfig.ActionMode.REPLACE) {
                    message = message.replace(i.search, i.replace);
                    continue;
                }
                message = "";
            }
        }
        this.message = message;
        return this;
    }

    public DiscordMessageBuilder afterSend(Runnable afterSend) {
        this.afterSend = afterSend;
        return this;
    }

    public DiscordMessage build() {
        if (this.author == null) {
            this.author = DiscordAuthor.SERVER;
        }
        if (this.message == null) {
            this.message = "";
        }
        return new DiscordMessage(this);
    }

    public String getMessage() {
        return this.message;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public DiscordAuthor getAuthor() {
        return this.author;
    }

    public Runnable getAfterSend() {
        return this.afterSend;
    }
}

