/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.sdlink.api.messaging.discord;

import com.hypherionmc.sdlink.api.accounts.DiscordAuthor;
import com.hypherionmc.sdlink.api.messaging.MessageType;
import com.hypherionmc.sdlink.api.messaging.discord.DiscordMessageBuilder;
import com.hypherionmc.sdlink.core.config.SDLinkConfig;
import com.hypherionmc.sdlink.core.config.impl.MessageChannelConfig;
import com.hypherionmc.sdlink.core.discord.BotController;
import com.hypherionmc.sdlink.core.managers.CacheManager;
import com.hypherionmc.sdlink.core.managers.ChannelManager;
import com.hypherionmc.sdlink.core.managers.EmbedManager;
import com.hypherionmc.sdlink.shaded.club.minnced.discord.webhook.send.WebhookEmbed;
import com.hypherionmc.sdlink.shaded.club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import com.hypherionmc.sdlink.shaded.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.EmbedBuilder;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.MessageEmbed;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.data.DataArray;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.api.utils.data.DataObject;
import com.hypherionmc.sdlink.shaded.dv8tion.jda.internal.utils.Checks;
import com.hypherionmc.sdlink.util.DestinationHolder;
import com.hypherionmc.sdlink.util.SDLinkUtils;
import java.awt.Color;
import java.time.Instant;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.NotNull;

public final class DiscordMessage {
    private final MessageType messageType;
    private final DiscordAuthor author;
    private final String message;
    private final Runnable afterSend;

    DiscordMessage(DiscordMessageBuilder builder) {
        this.messageType = builder.getMessageType();
        this.author = builder.getAuthor();
        this.message = builder.getMessage();
        this.afterSend = builder.getAfterSend();
    }

    public void sendMessage() {
        block8: {
            if (!BotController.INSTANCE.isBotReady()) {
                return;
            }
            if (this.message.isEmpty()) {
                return;
            }
            BotController.INSTANCE.getSpamManager().receiveMessage(String.format("%s:%s", this.author.getUsername(), this.message));
            if (BotController.INSTANCE.getSpamManager().isBlocked(String.format("%s:%s", this.author.getUsername(), this.message))) {
                if (SDLinkConfig.INSTANCE.generalConfig.debugging) {
                    BotController.INSTANCE.getLogger().warn("Blocked message {} due to spam", (Object)this.message);
                }
                return;
            }
            try {
                if (this.messageType == MessageType.CONSOLE) {
                    this.sendConsoleMessage();
                } else {
                    this.sendNormalMessage();
                }
            }
            catch (Exception e) {
                this.runAfterSend();
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block8;
                BotController.INSTANCE.getLogger().error("Failed to send Discord Message", (Throwable)e);
            }
        }
    }

    private void sendNormalMessage() {
        DestinationHolder channel = this.resolveDestination();
        if (channel.hasWebhook() && SDLinkConfig.INSTANCE.channelsAndWebhooks.webhooks.enabled) {
            WebhookMessageBuilder builder = new WebhookMessageBuilder();
            if (this.messageType == MessageType.CHAT) {
                builder.setUsername(SDLinkConfig.INSTANCE.channelsAndWebhooks.webhooks.webhookNameFormat.replace("%display_name%", this.author.getDisplayName()).replace("%mc_name%", this.author.getUsername()));
            } else {
                builder.setUsername(this.author.getDisplayName());
            }
            if (!this.author.getAvatar().isEmpty()) {
                builder.setAvatarUrl(this.author.getAvatar());
            }
            if (channel.useEmbed()) {
                EmbedBuilder eb = this.buildEmbed(false, channel.embedLayout());
                WebhookEmbed web = WebhookEmbedBuilder.fromJDA(eb.build()).build();
                builder.addEmbeds(web);
            } else {
                builder.setContent(this.message);
            }
            channel.webhook().send(builder.build()).thenRun(this::runAfterSend);
        } else {
            if (channel.channel() == null) {
                if (SDLinkConfig.INSTANCE.generalConfig.debugging) {
                    BotController.INSTANCE.getLogger().warn("Expected to get Channel for {}, but got null", (Object)this.messageType.name());
                }
                this.runAfterSend();
                return;
            }
            if (channel.useEmbed()) {
                EmbedBuilder eb = this.buildEmbed(true, channel.embedLayout());
                channel.channel().sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue(success -> this.runAfterSend());
            } else {
                channel.channel().sendMessage(this.messageType == MessageType.CHAT ? SDLinkConfig.INSTANCE.messageFormatting.chat.replace("%player%", this.author.getDisplayName()).replace("%mcname%", this.author.getProfile() == null ? "Unknown" : this.author.getProfile().getName()).replace("%message%", this.message) : this.message).queue(success -> this.runAfterSend());
            }
        }
    }

    private void runAfterSend() {
        if (this.afterSend != null) {
            this.afterSend.run();
        }
    }

    private void sendConsoleMessage() {
        block5: {
            try {
                if (!BotController.INSTANCE.isBotReady() || !SDLinkConfig.INSTANCE.chatConfig.sendConsoleMessages) {
                    return;
                }
                GuildMessageChannel channel = ChannelManager.getConsoleChannel();
                if (channel != null) {
                    channel.sendMessage(this.message).queue();
                }
            }
            catch (Exception e) {
                if (!SDLinkConfig.INSTANCE.generalConfig.debugging) break block5;
                BotController.INSTANCE.getLogger().error("Failed to send console message", (Throwable)e);
            }
        }
        if (this.afterSend != null) {
            this.afterSend.run();
        }
    }

    private EmbedBuilder buildEmbed(boolean withAuthor, String key) {
        String embedJson = EmbedManager.getEmbed(key);
        if (embedJson == null || embedJson.isEmpty()) {
            EmbedBuilder builder = new EmbedBuilder();
            if (withAuthor) {
                builder.setAuthor(this.author.getDisplayName(), null, this.author.getAvatar().isEmpty() ? null : this.author.getAvatar());
            }
            builder.setDescription(this.message);
            return builder;
        }
        embedJson = embedJson.replace("%author%", this.author.getDisplayName()).replace("%avatar%", this.author.getAvatar()).replace("%message_contents%", this.message).replace("%player_avatar%", this.author.getRealPlayerAvatar()).replace("%player_name%", this.author.getRealPlayerName()).replace("%current_time%", String.valueOf(Instant.now().getEpochSecond())).replace("%username%", this.author.getUsername().replace("_", "\\_"));
        DataObject object = DataObject.fromJson(embedJson);
        return this.fromData(object);
    }

    private DestinationHolder resolveDestination() {
        MessageChannelConfig.DestinationObject destinationObject = CacheManager.messageDestinations.get((Object)this.messageType);
        if (destinationObject != null) {
            return destinationObject.toHolder(this.messageType);
        }
        return SDLinkConfig.INSTANCE.messageDestinations.chat.toHolder(MessageType.CHAT);
    }

    @NotNull
    private EmbedBuilder fromData(@NotNull DataObject data) {
        Checks.notNull(data, "DataObject");
        EmbedBuilder builder = new EmbedBuilder();
        builder.setTitle(data.getString("title", null));
        builder.setUrl(data.getString("url", null));
        builder.setDescription(data.getString("description", ""));
        if (!data.isNull("timestamp")) {
            if (data.getString("timestamp").equalsIgnoreCase("1")) {
                builder.setTimestamp(Instant.now());
            } else if (!data.getString("timestamp").equalsIgnoreCase("0")) {
                builder.setTimestamp(OffsetDateTime.parse(data.getString("timestamp")));
            }
        }
        if (data.getString("color", "#000000").startsWith("#")) {
            builder.setColor(Color.decode(data.getString("color", "#000000")));
        } else {
            builder.setColor(data.getInt("color", 0x1FFFFFFF));
        }
        data.optObject("thumbnail").ifPresent(thumbnail -> builder.setThumbnail(SDLinkUtils.isNullOrEmpty(thumbnail.getString("url")) ? null : thumbnail.getString("url")));
        data.optObject("author").ifPresent(author -> builder.setAuthor(author.getString("name", ""), SDLinkUtils.isNullOrEmpty(author.getString("url", null)) ? null : author.getString("url", null), SDLinkUtils.isNullOrEmpty(author.getString("icon_url", null)) ? null : author.getString("icon_url", null)));
        data.optObject("footer").ifPresent(footer -> builder.setFooter(footer.getString("text", ""), SDLinkUtils.isNullOrEmpty(footer.getString("icon_url", null)) ? null : footer.getString("icon_url", null)));
        data.optObject("image").ifPresent(image -> builder.setImage(SDLinkUtils.isNullOrEmpty(image.getString("url")) ? null : image.getString("url")));
        data.optArray("fields").ifPresent(arr -> arr.stream(DataArray::getObject).forEach(field -> builder.addField(field.getString("name", "\u200e"), field.getString("value", "\u200e"), field.getBoolean("inline", false))));
        return builder;
    }
}

