/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.acetheeldritchking.art_of_forging.AoFRegistry;
import net.acetheeldritchking.art_of_forging.effects.BeheadingEffect;
import net.acetheeldritchking.art_of_forging.effects.CarnageEffect;
import net.acetheeldritchking.art_of_forging.effects.CavalryEffect;
import net.acetheeldritchking.art_of_forging.effects.ConqueringEffect;
import net.acetheeldritchking.art_of_forging.effects.DevouringEffect;
import net.acetheeldritchking.art_of_forging.effects.DismountingEffect;
import net.acetheeldritchking.art_of_forging.effects.DisorientingEffect;
import net.acetheeldritchking.art_of_forging.effects.DragonMistEffect;
import net.acetheeldritchking.art_of_forging.effects.EsotericEdgeEffect;
import net.acetheeldritchking.art_of_forging.effects.EvokingMawEffect;
import net.acetheeldritchking.art_of_forging.effects.FeastingEffect;
import net.acetheeldritchking.art_of_forging.effects.GoliathSlayerEffect;
import net.acetheeldritchking.art_of_forging.effects.HubrisEffect;
import net.acetheeldritchking.art_of_forging.effects.InfernalRebukeEffect;
import net.acetheeldritchking.art_of_forging.effects.JudgementEffect;
import net.acetheeldritchking.art_of_forging.effects.KnockbackEffect;
import net.acetheeldritchking.art_of_forging.effects.LifeFiberLossEffect;
import net.acetheeldritchking.art_of_forging.effects.LifeStealEffect;
import net.acetheeldritchking.art_of_forging.effects.NanoFusedEffect;
import net.acetheeldritchking.art_of_forging.effects.ResolveEffect;
import net.acetheeldritchking.art_of_forging.effects.RetributionEffect;
import net.acetheeldritchking.art_of_forging.effects.SlaughteringEffect;
import net.acetheeldritchking.art_of_forging.effects.SonicShockEffect;
import net.acetheeldritchking.art_of_forging.effects.SoulChargedEffect;
import net.acetheeldritchking.art_of_forging.effects.StormCallerEffect;
import net.acetheeldritchking.art_of_forging.effects.SubjugationEffect;
import net.acetheeldritchking.art_of_forging.effects.VengeanceEffect;
import net.acetheeldritchking.art_of_forging.effects.WitheringEffect;
import net.acetheeldritchking.art_of_forging.effects.curio.CurioFireResistanceEffect;
import net.acetheeldritchking.art_of_forging.effects.curio.CurioGlowingEffect;
import net.acetheeldritchking.art_of_forging.effects.curio.CurioHasteEffect;
import net.acetheeldritchking.art_of_forging.effects.curio.CurioKarmaEffect;
import net.acetheeldritchking.art_of_forging.effects.curio.CurioMagicResistanceEffect;
import net.acetheeldritchking.art_of_forging.effects.curio.CurioRegenerationEffect;
import net.acetheeldritchking.art_of_forging.effects.curio.CurioStrengthEffect;
import net.acetheeldritchking.art_of_forging.effects.potion.PotionEffects;
import net.acetheeldritchking.art_of_forging.item.AoFCreativeModeTab;
import net.acetheeldritchking.art_of_forging.item.ScrollHelper;
import net.acetheeldritchking.art_of_forging.loot.ModLootModifiers;
import net.acetheeldritchking.art_of_forging.networking.AoFPackets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import se.mickelus.tetra.TetraRegistries;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="art_of_forging")
public class ArtOfForging {
    public static final String MOD_ID = "art_of_forging";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RegistryObject<Item> tetraScroll = RegistryObject.create((ResourceLocation)new ResourceLocation("tetra:scroll_rolled"), (ResourceLocation)TetraRegistries.items.getRegistryName(), (String)"tetra");

    public ArtOfForging() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        bus.addListener(this::enqueueIMC);
        AoFRegistry.ITEMS.register(bus);
        AoFCreativeModeTab.register(bus);
        ModLootModifiers.register(bus);
        PotionEffects.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)new WitheringEffect());
        MinecraftForge.EVENT_BUS.register((Object)new StormCallerEffect());
        MinecraftForge.EVENT_BUS.register((Object)new EvokingMawEffect());
        MinecraftForge.EVENT_BUS.register((Object)new LifeStealEffect());
        MinecraftForge.EVENT_BUS.register((Object)new KnockbackEffect());
        MinecraftForge.EVENT_BUS.register((Object)new LifeFiberLossEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CavalryEffect());
        MinecraftForge.EVENT_BUS.register((Object)new DismountingEffect());
        MinecraftForge.EVENT_BUS.register((Object)new DragonMistEffect());
        MinecraftForge.EVENT_BUS.register((Object)new DisorientingEffect());
        MinecraftForge.EVENT_BUS.register((Object)new VengeanceEffect());
        MinecraftForge.EVENT_BUS.register((Object)new ResolveEffect());
        MinecraftForge.EVENT_BUS.register((Object)new DevouringEffect());
        MinecraftForge.EVENT_BUS.register((Object)new InfernalRebukeEffect());
        MinecraftForge.EVENT_BUS.register((Object)new HubrisEffect());
        MinecraftForge.EVENT_BUS.register((Object)new SlaughteringEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CarnageEffect());
        MinecraftForge.EVENT_BUS.register((Object)new JudgementEffect());
        MinecraftForge.EVENT_BUS.register((Object)new RetributionEffect());
        MinecraftForge.EVENT_BUS.register((Object)new EsotericEdgeEffect());
        MinecraftForge.EVENT_BUS.register((Object)new FeastingEffect());
        MinecraftForge.EVENT_BUS.register((Object)new NanoFusedEffect());
        MinecraftForge.EVENT_BUS.register((Object)new BeheadingEffect());
        MinecraftForge.EVENT_BUS.register((Object)new SoulChargedEffect());
        MinecraftForge.EVENT_BUS.register((Object)new SonicShockEffect());
        MinecraftForge.EVENT_BUS.register((Object)new ConqueringEffect());
        MinecraftForge.EVENT_BUS.register((Object)new SubjugationEffect());
        MinecraftForge.EVENT_BUS.register((Object)new GoliathSlayerEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CurioFireResistanceEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CurioMagicResistanceEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CurioStrengthEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CurioRegenerationEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CurioKarmaEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CurioHasteEffect());
        MinecraftForge.EVENT_BUS.register((Object)new CurioGlowingEffect());
        bus.addListener(this::buildCreativeTab);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> AoFPackets.register());
    }

    public void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().size(1).build());
    }

    public void buildCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().m_135782_().equals((Object)new ResourceLocation("tetra:default"))) {
            LOGGER.info("Registering AoF schematics with Tetra creative tab");
            event.m_246342_(this.setupSchematic("tetra/flamberge_blade", MOD_ID, new String[]{"sword/flamberge_blade"}, false, 2, 16750098, 6, 15, 4, 7));
            event.m_246342_(this.setupSchematic("single/head/halberd_head/halberd_head", MOD_ID, new String[]{"single/head/halberd_head/halberd_head"}, false, 1, 0x444AFF, 8, 1, 4, 5));
            event.m_246342_(this.setupSchematic("sword/key_guard", MOD_ID, new String[]{"sword/key_guard"}, false, 1, 16442377, 0, 1, 9, 4));
            event.m_246342_(this.setupSchematic("single/head/mace_head/mace_head", MOD_ID, new String[]{"single/head/mace_head/mace_head"}, false, 1, 0x560060, 9, 3, 6, 2));
            event.m_246342_(this.setupSchematic("tetra/crucible_blade", MOD_ID, new String[]{"sword/crucible_blade"}, false, 2, 16719360, 8, 7, 9, 2));
            event.m_246342_(this.setupSchematic("bow/stave/dreadnought_stave", MOD_ID, new String[]{"bow/stave/dreadnought_stave", "bow/stave/dreadnought_cross_stave"}, false, 1, 15971103, 8, 1, 9, 5));
            event.m_246342_(this.setupSchematic("sword/katana/katana_blade", MOD_ID, new String[]{"sword/katana/katana_blade", "sword/tsuba_guard"}, false, 2, 14417680, 5, 10, 13, 2));
            event.m_246342_(this.setupSchematic("bow/string/compound_string", MOD_ID, new String[]{"bow/string/compound_string", "crossbow/string/compound_cross_string"}, false, 1, 1697160, 15, 13, 12, 14));
            event.m_246342_(this.setupSchematic("utilize/hammer", MOD_ID, new String[]{"utilize/hammer"}, false, 2, 16422889, 1, 15, 12, 8));
            event.m_246342_(this.setupSchematic("sword/katana/murasama_blade", "otherworldly", new String[]{"sword/katana/murasama_blade"}, false, 2, 12919587, 6, 7, 13, 15));
            event.m_246342_(this.setupSchematic("tetra/rending_scissor_complete", "otherworldly", new String[]{"sword/scissor_blade_left", "sword/scissor_blade_right", "sword/rending_scissor_complete"}, false, 2, 14885250, 1, 15, 2, 13));
            event.m_246342_(this.setupSchematic("sword/crucible/architects_crucible_blade", "true_crucible", new String[]{"sword/crucible_blade", "sword/crucible/architects_crucible_blade"}, true, 2, 16711746, 8, 7, 9, 2));
            event.m_246342_(this.setupSchematic("sword/tonal_blade", MOD_ID, new String[]{"sword/tonal_blade"}, false, 1, 14350246, 3, 5, 6, 9));
            event.m_246342_(this.setupSchematic("sword/thousand_cold_nights", "otherworldly", new String[]{"sword/katana/murasama_blade", "sword/thousand_cold_nights"}, true, 2, 6061184, 7, 8, 14, 13));
        }
    }

    private ItemStack setupSchematic(String key, String details, String[] schematics, boolean isIntricate, int material, int tint, Integer ... glyphs) {
        ScrollHelper data = new ScrollHelper(key, Optional.ofNullable(details), isIntricate, material, tint, Arrays.asList(glyphs), Arrays.stream(schematics).map(s -> new ResourceLocation("tetra", s)).collect(Collectors.toList()), Collections.emptyList());
        ItemStack itemStack = new ItemStack((ItemLike)tetraScroll.get());
        data.write(itemStack);
        return itemStack;
    }

    @Mod.EventBusSubscriber(modid="art_of_forging", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

