/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IOnePlayerInteractable;
import net.mehvahdjukaar.supplementaries.common.block.IWaxable;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public interface ITextHolderProvider
extends IOnePlayerInteractable,
IWashable,
IWaxable {
    public TextHolder getTextHolder(int var1);

    default public TextHolder getTextHolder() {
        return this.getTextHolder(0);
    }

    default public TextHolder getTextHolderAt(Vec3 hit) {
        return this.getTextHolder();
    }

    default public int textHoldersCount() {
        return 1;
    }

    default public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        if (this.isWaxed()) {
            this.setWaxed(false);
            return true;
        }
        boolean success = false;
        TextHolder text = this.getTextHolderAt(hitVec);
        if (!text.isEmpty(null)) {
            text.clear();
            success = true;
        }
        if (success) {
            ITextHolderProvider iTextHolderProvider = this;
            if (iTextHolderProvider instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)iTextHolderProvider;
                be.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
            return true;
        }
        return false;
    }

    default public boolean tryAcceptingClientText(BlockPos pos, ServerPlayer player, List<List<FilteredText>> filteredText) {
        if (!this.isWaxed() && this.isEditingPlayer((Player)player)) {
            for (int i = 0; i < filteredText.size(); ++i) {
                TextHolder holder = this.getTextHolder(i);
                holder.acceptClientMessages((Player)player, filteredText.get(i));
            }
            this.setPlayerWhoMayEdit(null);
            return true;
        }
        Supplementaries.LOGGER.warn("Player {} just tried to change non-editable sign", (Object)player.m_7755_().getString());
        return false;
    }

    @Override
    default public boolean tryOpeningEditGui(ServerPlayer player, BlockPos pos, ItemStack stack) {
        boolean filtering = player.m_143387_();
        for (int i = 0; i < this.textHoldersCount(); ++i) {
            if (this.getTextHolder(i).hasEditableText(filtering)) continue;
            return false;
        }
        return IOnePlayerInteractable.super.tryOpeningEditGui(player, pos, stack);
    }

    default public InteractionResult interactWithTextHolder(int index, Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        ServerPlayer serverPlayer;
        InteractionResult result = this.getTextHolder(index).playerInteract(level, pos, player, hand);
        if (result == InteractionResult.PASS) {
            result = this.tryWaxing(level, pos, player, hand);
        }
        if (result != InteractionResult.PASS) {
            ITextHolderProvider iTextHolderProvider;
            if (!level.f_46443_ && (iTextHolderProvider = this) instanceof BlockEntity) {
                BlockEntity te = (BlockEntity)iTextHolderProvider;
                te.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)level.m_8055_(pos)));
            return result;
        }
        if (player instanceof ServerPlayer && this.tryOpeningEditGui(serverPlayer = (ServerPlayer)player, pos, player.m_21120_(hand))) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }
}

