/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class CannonScreen
extends AbstractContainerScreen<CannonContainerMenu>
implements ContainerListener {
    private final CannonBlockTile tile;
    private NumberEditBox pitchSelector;
    private NumberEditBox yawSelector;
    private PowerSelectorWidget powerSelector;

    public CannonScreen(CannonContainerMenu menu, Inventory inventory, Component text) {
        super((AbstractContainerMenu)menu, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.tile = menu.getContainer();
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 8;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_142416_((GuiEventListener)new ManouverButton(i + 154, j + 10 + 6));
        this.yawSelector = (NumberEditBox)this.m_142416_((GuiEventListener)new NumberEditBox(this.f_96547_, i + 144, j + 49 + 6, 18, 10));
        this.yawSelector.setNumber(this.tile.getYaw());
        this.pitchSelector = (NumberEditBox)this.m_142416_((GuiEventListener)new NumberEditBox(this.f_96547_, i + 144, j + 29 + 6, 18, 10));
        this.pitchSelector.setNumber(this.tile.getPitch());
        this.powerSelector = (PowerSelectorWidget)this.m_142416_((GuiEventListener)new PowerSelectorWidget(i + 18, j + 24, 4));
        this.powerSelector.power = this.tile.getPowerLevel();
        ((CannonContainerMenu)this.f_97732_).m_38893_(this);
    }

    private void onManeuverPressed(Button button) {
        CannonController.startControlling(this.tile);
        this.m_7379_();
    }

    public void m_7379_() {
        super.m_7379_();
        float yaw = this.yawSelector.getNumber();
        float pitch = this.pitchSelector.getNumber();
        byte power = this.powerSelector.getPower();
        this.tile.setAttributes(yaw, pitch, power, false, (Player)this.f_96541_.f_91074_);
        CannonBlockTile.syncToServer(this.tile, false, !CannonController.isActive());
    }

    private int getActualPower() {
        return Math.min(this.powerSelector.getPower(), this.tile.getFuel().m_41613_());
    }

    public void m_7934_(AbstractContainerMenu container, int slot, ItemStack stack) {
        if (slot == 0) {
            // empty if block
        }
    }

    public void m_142153_(AbstractContainerMenu container, int dataSlotIndex, int value) {
        this.m_7934_(container, 0, container.m_38853_(0).m_7993_());
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(Supplementaries.res("textures/gui/cannon_gui.png"), k, l, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int x, int y) {
        super.m_280003_(graphics, x, y);
        int color = 0x404040;
        byte wantedPower = this.powerSelector.getPower();
        if (wantedPower > this.getActualPower()) {
            color = ChatFormatting.GRAY.m_126665_();
        }
        graphics.m_280056_(this.f_96547_, wantedPower + "x", 37, 25, color, false);
    }

    public boolean m_7933_(int key, int a, int b) {
        return super.m_7933_(key, a, b);
    }

    public void m_181908_() {
        super.m_181908_();
        this.yawSelector.m_94120_();
        this.pitchSelector.m_94120_();
    }

    public void m_7861_() {
        super.m_7861_();
        ((CannonContainerMenu)this.f_97732_).m_38943_(this);
    }

    private final class ManouverButton
    extends Button {
        public ManouverButton(int x, int y) {
            super(x, y, 10, 10, (Component)Component.m_237119_(), CannonScreen.this::onManeuverPressed, Button.f_252438_);
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.supplementaries.cannon.maneuver")));
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
            int x = 176;
            int y = 36;
            if (this.m_274382_()) {
                x += this.f_93618_;
            }
            guiGraphics.m_280218_(ModTextures.CANNON_GUI_TEXTURE, this.m_252754_(), this.m_252907_(), x, y, this.f_93618_, this.f_93619_);
        }
    }

    private static class NumberEditBox
    extends EditBox {
        public NumberEditBox(Font font, int x, int y, int width, int height) {
            super(font, x, y, width, height, (Component)Component.m_237119_());
            this.m_94199_(4);
            this.m_94182_(false);
            this.m_94153_(this::isValidAngle);
        }

        private boolean isValidAngle(String str) {
            try {
                if (str.isEmpty() || str.equals("+") || str.equals("-")) {
                    return true;
                }
                double d = Double.parseDouble(str);
                if (str.contains("[a-zA-Z]+")) {
                    return false;
                }
                return d <= 360.0 && d >= -360.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public void setNumber(float value) {
            this.m_94144_(String.valueOf((int)value));
        }

        public float getNumber() {
            try {
                return Float.parseFloat(this.m_94155_());
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
    }

    private class PowerSelectorWidget
    extends AbstractWidget {
        private final byte levels;
        private byte power;

        public PowerSelectorWidget(int x, int y, int levels) {
            super(x, y, 12, 36, (Component)Component.m_237119_());
            this.power = (byte)2;
            this.levels = (byte)levels;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
            byte hoveredLevel = 0;
            int levelH = this.f_93619_ / this.levels;
            if (this.f_93622_) {
                hoveredLevel = this.getSelectedHoveredLevel(mouseY);
            }
            int actualPower = CannonScreen.this.getActualPower();
            for (int p = 1; p <= this.levels; ++p) {
                int selectedH = levelH * p;
                int y = this.f_93619_ - selectedH;
                int x = 176 + (p == hoveredLevel ? this.f_93618_ : 0);
                if (p > this.power) {
                    x += this.f_93618_ * 2;
                } else if (p > actualPower) {
                    x += this.f_93618_ * 4;
                }
                guiGraphics.m_280218_(Supplementaries.res("textures/gui/cannon_gui.png"), this.m_252754_(), this.m_252907_() + y, x, y, this.f_93618_, levelH);
            }
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.power = this.getSelectedHoveredLevel(mouseY);
        }

        private byte getSelectedHoveredLevel(double mouseY) {
            float levelH = (float)this.f_93619_ / (float)this.levels;
            return (byte)((double)this.levels - Math.floor((mouseY - (double)this.m_252907_()) / (double)levelH));
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }

        public byte getPower() {
            return this.power;
        }
    }
}

