/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.discord;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.NotNull;
import shadow.hypherionmc.mcdiscordformatter.discord.DiscordSerializerOptions;
import shadow.hypherionmc.mcdiscordformatter.text.Text;

public class DiscordSerializer {
    public static final DiscordSerializer INSTANCE = new DiscordSerializer(){

        @Override
        public void setDefaultOptions(DiscordSerializerOptions defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setKeybindProvider(Function<KeybindContents, String> provider) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setTranslationProvider(Function<MutableComponent, String> provider) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    private DiscordSerializerOptions defaultOptions;
    private Function<KeybindContents, String> keybindProvider;
    private Function<MutableComponent, String> translationProvider;

    public DiscordSerializer() {
        this(DiscordSerializerOptions.defaults());
    }

    public DiscordSerializer(@NotNull DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
        this.translationProvider = defaultOptions.getTranslationProvider();
        this.keybindProvider = defaultOptions.getKeybindProvider();
    }

    @Deprecated
    public Function<KeybindContents, String> getKeybindProvider() {
        return this.keybindProvider;
    }

    @Deprecated
    public void setKeybindProvider(Function<KeybindContents, String> provider) {
        this.keybindProvider = provider;
    }

    @Deprecated
    public Function<MutableComponent, String> getTranslationProvider() {
        return this.translationProvider;
    }

    @Deprecated
    public void setTranslationProvider(Function<MutableComponent, String> provider) {
        this.translationProvider = provider;
    }

    public String serialize(@NotNull MutableComponent component) {
        DiscordSerializerOptions options = this.getDefaultOptions();
        if (this.keybindProvider != null) {
            options = options.withKeybindProvider(this.keybindProvider);
        }
        if (this.translationProvider != null) {
            options = options.withTranslationProvider(this.translationProvider);
        }
        return this.serialize(component, options);
    }

    @Deprecated
    public String serialize(@NotNull MutableComponent component, boolean embedLinks) {
        return this.serialize(component, this.defaultOptions.withEmbedLinks(embedLinks));
    }

    public String serialize(@NotNull MutableComponent component, @NotNull DiscordSerializerOptions serializerOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<Text> texts = this.getTexts(new LinkedList<Text>(), component, new Text(), serializerOptions);
        for (Text text : texts) {
            String content = text.getContent();
            if (content.isEmpty()) continue;
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (serializerOptions.isEscapeMarkdown()) {
                content = content.replace("(?<!\\\\)(?:\\\\\\\\)*\\*", "\\*").replace("(?<!\\\\)(?:\\\\\\\\)*~", "\\~").replace("(?<!\\\\)(?:\\\\\\\\)*_", "\\_").replace("(?<!\\\\)(?:\\\\\\\\)*`", "\\`").replace("(?<!\\\\)(?:\\\\\\\\)*\\|", "\\|");
            }
            stringBuilder.append(ChatFormatting.m_126649_((String)content));
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            stringBuilder.append("\u200b");
        }
        int length = stringBuilder.length();
        return length < 1 ? "" : stringBuilder.substring(0, length - 1);
    }

    private LinkedList<Text> getTexts(@NotNull List<Text> input, @NotNull MutableComponent component, @NotNull Text text, @NotNull DiscordSerializerOptions serializerOptions) {
        Text previous;
        String content;
        LinkedList<Text> output = new LinkedList<Text>(input);
        if (component.m_214077_() instanceof KeybindContents) {
            KeybindContents keybindComponent = (KeybindContents)component.m_214077_();
            content = this.keybindProvider.apply(keybindComponent);
        } else if (component.m_214077_() instanceof ScoreContents) {
            ScoreContents scoreText = (ScoreContents)component.m_214077_();
            content = scoreText.m_237453_();
        } else if (component.m_214077_() instanceof SelectorContents) {
            SelectorContents selectorText = (SelectorContents)component.m_214077_();
            content = selectorText.m_237466_();
        } else {
            content = component.m_214077_() instanceof LiteralContents ? component.getString() : (component.m_214077_() instanceof TranslatableContents ? this.translationProvider.apply(component) : "");
        }
        ClickEvent clickEvent = component.m_7383_().m_131182_();
        if (serializerOptions.isEmbedLinks() && clickEvent != null && clickEvent.m_130622_() == ClickEvent.Action.OPEN_URL) {
            text.setContent("[" + content + "](" + clickEvent.m_130623_() + ")");
        } else {
            text.setContent(content);
        }
        if (component.m_7383_().m_131154_()) {
            text.setBold(true);
        }
        text.setBold(component.m_7383_().m_131154_());
        text.setItalic(component.m_7383_().m_131161_());
        text.setUnderline(component.m_7383_().m_131171_());
        text.setStrikethrough(component.m_7383_().m_131168_());
        if (!output.isEmpty() && text.formattingMatches(previous = output.getLast())) {
            output.removeLast();
            text.setContent(previous.getContent() + text.getContent());
        }
        output.add(text);
        for (Component child : component.m_7360_()) {
            Text next = text.clone();
            next.setContent("");
            output = this.getTexts(output, (MutableComponent)child, next, serializerOptions);
        }
        return output;
    }

    public DiscordSerializerOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
    }
}

