/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.mixin;

import com.hypherionmc.craterlib.client.gui.config.ClothConfigScreenBuilder;
import com.hypherionmc.craterlib.client.gui.config.CraterConfigScreen;
import com.hypherionmc.craterlib.core.config.AbstractConfig;
import com.hypherionmc.craterlib.core.config.ConfigController;
import com.hypherionmc.craterlib.core.config.annotations.ClothScreen;
import com.hypherionmc.craterlib.core.config.annotations.NoConfigScreen;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.forgespi.language.IModInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ConfigScreenHandler.class})
public class ConfigScreenHandlerMixin {
    @Inject(at={@At(value="RETURN")}, method={"getScreenFactoryFor"}, cancellable=true, remap=false)
    private static void injectConfigScreen(IModInfo selectedMod, CallbackInfoReturnable<Optional<BiFunction<Minecraft, Screen, Screen>>> cir) {
        ConfigController.getWatchedConfigs().forEach((conf, config) -> {
            if (config.getClass().isAnnotationPresent(NoConfigScreen.class)) {
                return;
            }
            if (config.getModId().equals(selectedMod.getModId())) {
                if (config.getClass().isAnnotationPresent(ClothScreen.class) && ModloaderEnvironment.INSTANCE.isModLoaded("cloth_config")) {
                    cir.setReturnValue(Optional.of((minecraft, screen) -> ClothConfigScreenBuilder.buildConfigScreen(config, screen)));
                } else {
                    cir.setReturnValue(Optional.of((minecraft, screen) -> new CraterConfigScreen((AbstractConfig)config, (Screen)screen)));
                }
            }
        });
    }
}

