/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.api.commands;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.compat.LuckPermsCompat;
import com.hypherionmc.craterlib.core.platform.LoaderType;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import com.hypherionmc.craterlib.nojang.commands.BridgedCommandSourceStack;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import com.hypherionmc.craterlib.utils.TriConsumer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;

public class CraterCommand {
    private final LiteralArgumentBuilder<CommandSourceStack> mojangCommand;
    private int permLevel = 4;
    private String luckPermNode = "";

    CraterCommand(LiteralArgumentBuilder<CommandSourceStack> cmd) {
        this.mojangCommand = cmd;
    }

    public static CraterCommand literal(String commandName) {
        return new CraterCommand((LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)commandName));
    }

    public CraterCommand requiresPermission(int perm) {
        this.permLevel = perm;
        this.mojangCommand.requires(this::checkPermission);
        return this;
    }

    public CraterCommand withNode(String key) {
        this.luckPermNode = key;
        return this;
    }

    public CraterCommand then(CraterCommand child) {
        this.mojangCommand.then(child.mojangCommand);
        return this;
    }

    public CraterCommand withGameProfilesArgument(String key, CommandExecutorWithArgs<List<BridgedGameProfile>> executor) {
        this.mojangCommand.then(Commands.m_82129_((String)key, (ArgumentType)GameProfileArgument.m_94584_()).executes(context -> executor.run(BridgedPlayer.of((Player)((CommandSourceStack)context.getSource()).m_230896_()), GameProfileArgument.m_94590_((CommandContext)context, (String)key).stream().map(BridgedGameProfile::of).toList(), BridgedCommandSourceStack.of((CommandSourceStack)context.getSource()))));
        return this;
    }

    public CraterCommand withBoolArgument(String key, CommandExecutorWithArgs<Boolean> executor) {
        this.mojangCommand.then(Commands.m_82129_((String)key, (ArgumentType)BoolArgumentType.bool()).executes(context -> executor.run(BridgedPlayer.of((Player)((CommandSourceStack)context.getSource()).m_230896_()), BoolArgumentType.getBool((CommandContext)context, (String)key), BridgedCommandSourceStack.of((CommandSourceStack)context.getSource()))));
        return this;
    }

    public CraterCommand withWordArgument(String key, CommandExecutorWithArgs<String> executor) {
        this.mojangCommand.then(Commands.m_82129_((String)key, (ArgumentType)StringArgumentType.word()).executes(context -> executor.run(BridgedPlayer.of((Player)((CommandSourceStack)context.getSource()).m_230896_()), StringArgumentType.getString((CommandContext)context, (String)key), BridgedCommandSourceStack.of((CommandSourceStack)context.getSource()))));
        return this;
    }

    public CraterCommand withStringArgument(String key, CommandExecutorWithArgs<String> executor) {
        this.mojangCommand.then(Commands.m_82129_((String)key, (ArgumentType)StringArgumentType.string()).executes(context -> executor.run(BridgedPlayer.of((Player)((CommandSourceStack)context.getSource()).m_230896_()), StringArgumentType.getString((CommandContext)context, (String)key), BridgedCommandSourceStack.of((CommandSourceStack)context.getSource()))));
        return this;
    }

    public CraterCommand withPhraseArgument(String key, CommandExecutorWithArgs<String> executor) {
        this.mojangCommand.then(Commands.m_82129_((String)key, (ArgumentType)StringArgumentType.greedyString()).executes(context -> executor.run(BridgedPlayer.of((Player)((CommandSourceStack)context.getSource()).m_230896_()), StringArgumentType.getString((CommandContext)context, (String)key), BridgedCommandSourceStack.of((CommandSourceStack)context.getSource()))));
        return this;
    }

    public CraterCommand withIntegerArgument(String key, CommandExecutorWithArgs<Integer> executor) {
        this.mojangCommand.then(Commands.m_82129_((String)key, (ArgumentType)IntegerArgumentType.integer()).executes(context -> executor.run(BridgedPlayer.of((Player)((CommandSourceStack)context.getSource()).m_230896_()), IntegerArgumentType.getInteger((CommandContext)context, (String)key), BridgedCommandSourceStack.of((CommandSourceStack)context.getSource()))));
        return this;
    }

    public CraterCommand execute(SingleCommandExecutor<BridgedCommandSourceStack> executor) {
        this.mojangCommand.executes(context -> executor.run(BridgedCommandSourceStack.of((CommandSourceStack)context.getSource())));
        return this;
    }

    @Deprecated(forRemoval=true)
    public CraterCommand executes(Consumer<BridgedCommandSourceStack> ctx) {
        return this.execute(stack -> {
            ctx.accept((BridgedCommandSourceStack)stack);
            return 1;
        });
    }

    @Deprecated(forRemoval=true)
    public CraterCommand withGameProfileArgument(String key, TriConsumer<BridgedPlayer, List<BridgedGameProfile>, BridgedCommandSourceStack> executor) {
        return this.withGameProfilesArgument(key, (player, argument, stack) -> {
            executor.accept(player, (List<BridgedGameProfile>)argument, stack);
            return 1;
        });
    }

    @ApiStatus.Internal
    public void register(CommandDispatcher<CommandSourceStack> stack) {
        stack.register(this.mojangCommand);
    }

    private boolean checkPermission(CommandSourceStack stack) {
        try {
            if (!ModloaderEnvironment.INSTANCE.isModLoaded("luckperms") || ModloaderEnvironment.INSTANCE.getLoaderType() == LoaderType.PAPER || !stack.m_230897_() || this.luckPermNode.isEmpty()) {
                return stack.m_6761_(this.permLevel);
            }
            return LuckPermsCompat.INSTANCE.hasPermission(stack.m_230896_(), this.luckPermNode) || stack.m_6761_(this.permLevel);
        }
        catch (Exception e) {
            CraterConstants.LOG.error("Failed to check luckperms permissions", (Throwable)e);
            return stack.m_6761_(this.permLevel);
        }
    }

    @FunctionalInterface
    public static interface CommandExecutorWithArgs<S> {
        public int run(BridgedPlayer var1, S var2, BridgedCommandSourceStack var3);
    }

    @FunctionalInterface
    public static interface SingleCommandExecutor<S> {
        public int run(S var1);
    }
}

