/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.integration.jei;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oitsjustjose.vtweaks.common.data.fluidconversion.FluidConversionRecipe;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class FluidConversionRecipeCategory
implements IRecipeCategory<FluidConversionRecipe> {
    public static final RecipeType<FluidConversionRecipe> TYPE = RecipeType.create((String)"vtweaks", (String)"fluid_conversion", FluidConversionRecipe.class);
    public static final ItemStack SPLASH_POTION = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43599_);
    private final IDrawable background;
    private final IDrawable icon;

    public FluidConversionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("vtweaks", "textures/gui/fluid_conversion.png"), 0, 0, 76, 18).addPadding(0, 20, 32, 32).setTextureSize(76, 18).build();
        this.icon = guiHelper.createDrawableItemStack(SPLASH_POTION);
    }

    @Nonnull
    public RecipeType<FluidConversionRecipe> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        try {
            return new TranslatableContents("vtweaks.fluid_conversion.jei.title", null, new Object[0]).m_213698_(null, null, 0);
        }
        catch (CommandSyntaxException ex) {
            return Component.m_237119_();
        }
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, FluidConversionRecipe recipe, @NotNull IFocusGroup focuses) {
        Ingredient input = recipe.getInput();
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getFluid());
        ItemStack output = recipe.getResult();
        if (fluid == null) {
            return;
        }
        IRecipeSlotBuilder inputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 33, 1).addIngredients(input)).setSlotName("inputSlot");
        IRecipeSlotBuilder fluidSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 33, 1).addFluidStack(fluid, 1000L)).setSlotName("fluidSlot");
        IRecipeSlotBuilder outputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).addItemStack(output)).setSlotName("outputSlot");
    }

    public void draw(FluidConversionRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getFluid());
        if (fluid == null) {
            return;
        }
        MutableComponent comp = Component.m_237119_();
        try {
            MutableComponent fluidNm = fluid.getFluidType().getDescription().m_214077_().m_213698_(null, null, 0);
            comp.m_7220_((Component)new TranslatableContents("vtweaks.fluid_conversion.jei.text", "--", new Object[]{fluidNm}).m_213698_(null, null, 0));
        }
        catch (CommandSyntaxException fluidNm) {
            // empty catch block
        }
        Minecraft minecraft = Minecraft.m_91087_();
        int width = minecraft.f_91062_.m_92852_((FormattedText)comp);
        int x = this.background.getWidth() - 2 - width;
        int y = 27;
        guiGraphics.m_280430_(minecraft.f_91062_, (Component)comp, x + 1, y + 1, 0x25252525);
        guiGraphics.m_280430_(minecraft.f_91062_, (Component)comp, x, y, 0x252525);
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

