/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.player;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(category="player")
public class FeatherFallingTweak
extends VTweak {
    private ForgeConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("Feather Falling IV or above directs 100% of fall damage to boots").define("enableFeatherFallTweak", true);
    }

    @SubscribeEvent
    public void process(LivingHurtEvent evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (!evt.getSource().m_276093_(DamageTypes.f_268671_)) {
            return;
        }
        LivingEntity livingEntity = evt.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack boots = player.m_150109_().m_36052_(0);
        if (boots.m_41619_()) {
            return;
        }
        if (boots.getEnchantmentLevel(Enchantments.f_44967_) < 4) {
            return;
        }
        if (boots.m_220157_((int)evt.getAmount(), player.m_217043_(), player)) {
            boots.m_41774_(1);
        }
        evt.setAmount(0.0f);
    }
}

