/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity.challenger;

import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import com.oitsjustjose.vtweaks.common.entity.ChallengerEntityModifier;
import com.oitsjustjose.vtweaks.common.tweaks.entity.challenger.ChallengerHelpers;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector3f;

@Tweak(category="client")
public class ChallengerParticleHandler
extends VTweak {
    private ForgeConfigSpec.BooleanValue enable;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enable = builder.comment("Enable colored particles for challenger mobs (dependent on particle setting as well)").define("enableChallengerMobParticles", true);
    }

    @SubscribeEvent
    public void process(LivingEvent.LivingTickEvent evt) {
        if (!((Boolean)this.enable.get()).booleanValue()) {
            return;
        }
        if (evt.getEntity() == null) {
            return;
        }
        if (!evt.getEntity().m_6084_()) {
            return;
        }
        LivingEntity livingEntity = evt.getEntity();
        if (!(livingEntity instanceof Monster)) {
            return;
        }
        Monster monster = (Monster)livingEntity;
        ChallengerEntityModifier modifier = ChallengerHelpers.getChallengerEntityModifier((Entity)monster);
        if (modifier != null) {
            RandomSource rand = monster.m_217043_();
            float noiseX = (float)(rand.m_188499_() ? 1 : -1) * rand.m_188501_() / 2.0f;
            float noiseZ = (float)(rand.m_188499_() ? 1 : -1) * rand.m_188501_() / 2.0f;
            double x = monster.m_20185_() + (double)noiseX;
            double y = rand.m_188499_() ? monster.m_20186_() + (double)(monster.m_20206_() / 2.0f) : monster.m_20186_();
            double z = monster.m_20189_() + (double)noiseZ;
            Vector3f color = modifier.getParticleColor();
            VTweaks.Proxy.addParticle(color.x(), color.y(), color.z(), x, y += (double)(rand.m_188501_() + (float)rand.m_188503_(1)), z);
        }
    }
}

