/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.block;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@Tweak(category="block")
public class CropInteractTweak
extends VTweak {
    public static final TagKey<Block> CROP_BLACKLIST = BlockTags.create((ResourceLocation)new ResourceLocation("vtweaks", "blacklisted_harvest_crops"));
    public ForgeConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment(new String[0]).define("enableCropTweaks", true);
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.RightClickBlock evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockPos pos = evt.getPos();
        BlockState state = evt.getLevel().m_8055_(pos);
        Player player = evt.getEntity();
        if (state.m_204336_(CROP_BLACKLIST)) {
            return;
        }
        if (!this.canHarvest(state)) {
            return;
        }
        Level level = evt.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLvl = (ServerLevel)level;
            this.harvest(serverLvl, pos, state, player, evt.getHitVec());
        }
        player.m_6674_(InteractionHand.MAIN_HAND);
        evt.setCanceled(true);
    }

    private boolean canHarvest(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return crop.m_52307_(state);
        }
        for (Map.Entry e : state.m_61148_().entrySet()) {
            IntegerProperty intProp;
            Object k = e.getKey();
            if (!(k instanceof IntegerProperty) || !(intProp = (IntegerProperty)k).m_61708_().equals("age")) continue;
            Integer max = intProp.m_6908_().stream().max(Comparator.comparingInt(a -> a)).orElse(0);
            Integer val = (Integer)state.m_61143_((Property)intProp);
            return val.equals(max);
        }
        return false;
    }

    private void harvest(ServerLevel level, BlockPos pos, BlockState state, Player player, BlockHitResult blockHitResult) {
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)level, (BlockPos)pos, null);
        level.m_46961_(pos, false);
        boolean planted = false;
        ItemStack pickItem = state.getCloneItemStack((HitResult)blockHitResult, (BlockGetter)level, pos, player);
        for (ItemStack drop : drops) {
            DirectionalPlaceContext ctx;
            BlockItem bi;
            Item item;
            if (!planted && ItemStack.m_150942_((ItemStack)drop, (ItemStack)pickItem) && (item = drop.m_41720_()) instanceof BlockItem && (bi = (BlockItem)item).m_40576_((BlockPlaceContext)(ctx = new DirectionalPlaceContext((Level)level, pos, Direction.DOWN, drop, Direction.UP))) == InteractionResult.SUCCESS) {
                drop.m_41774_(1);
                planted = true;
            }
            if (drop.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
        }
    }
}

