/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.entity;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oitsjustjose.vtweaks.common.data.helpers.VTJsonHelpers;
import com.oitsjustjose.vtweaks.common.util.WeightedCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class ChallengerEntityModifier {
    public static final WeightedCollection<ChallengerEntityModifier> AllVariants = new WeightedCollection();
    private final int weight;
    private final String unlocalizedName;
    private final double healthMultiplier;
    private final double speedMultiplier;
    private final ItemStack mainHand;
    private final ItemStack offHand;
    private final ItemStack helmet;
    private final ItemStack chestplate;
    private final ItemStack leggings;
    private final ItemStack boots;
    private final List<MobEffectInstance> effectsOnAttack;
    private final WeightedCollection<ItemStack> loot;
    private final List<ResourceLocation> entityFilter;
    private final boolean entityFilterIsBlacklist;
    Vector3f particleColor;

    public ChallengerEntityModifier(JsonObject json) {
        if (json == null) {
            throw new NullPointerException("Provided JSON is null");
        }
        this.weight = json.get("weight").getAsInt();
        JsonObject color = json.get("color").getAsJsonObject();
        float r = (float)color.get("red").getAsInt() / 255.0f;
        float g = (float)color.get("green").getAsInt() / 255.0f;
        float b = (float)color.get("blue").getAsInt() / 255.0f;
        this.particleColor = new Vector3f(r, g, b);
        this.unlocalizedName = json.get("unlocalizedName").getAsString();
        this.healthMultiplier = json.get("healthMultiplier").getAsDouble();
        this.speedMultiplier = json.get("speedMultiplier").getAsDouble();
        JsonObject gear = json.get("gear").getAsJsonObject();
        this.mainHand = VTJsonHelpers.deserializeItemStack(gear, "mainHand");
        this.offHand = VTJsonHelpers.deserializeItemStack(gear, "offHand");
        this.helmet = VTJsonHelpers.deserializeItemStack(gear, "helmet");
        this.chestplate = VTJsonHelpers.deserializeItemStack(gear, "chestplate");
        this.leggings = VTJsonHelpers.deserializeItemStack(gear, "leggings");
        this.boots = VTJsonHelpers.deserializeItemStack(gear, "boots");
        this.effectsOnAttack = VTJsonHelpers.deserializeEffectInstanceList(json.get("effectsOnAttack").getAsJsonArray());
        this.loot = VTJsonHelpers.deserializeLootTable(json.get("loot").getAsJsonArray());
        JsonObject entityFilter = json.get("entityFilter").getAsJsonObject();
        this.entityFilterIsBlacklist = entityFilter.get("isBlacklist").getAsBoolean();
        this.entityFilter = new ArrayList<ResourceLocation>();
        for (JsonElement e : entityFilter.get("entities").getAsJsonArray()) {
            this.entityFilter.add(new ResourceLocation(e.getAsString()));
        }
    }

    public void apply(Monster monster) {
        for (EquipmentSlot e : EquipmentSlot.values()) {
            monster.m_8061_(e, ItemStack.f_41583_);
            monster.m_21409_(e, 0.0f);
        }
        monster.m_8061_(EquipmentSlot.HEAD, this.helmet.m_41777_());
        monster.m_8061_(EquipmentSlot.CHEST, this.chestplate.m_41777_());
        monster.m_8061_(EquipmentSlot.LEGS, this.leggings.m_41777_());
        monster.m_8061_(EquipmentSlot.FEET, this.boots.m_41777_());
        monster.m_21008_(InteractionHand.MAIN_HAND, this.mainHand.m_41777_());
        monster.m_21008_(InteractionHand.OFF_HAND, this.offHand.m_41777_());
        double speed = Objects.requireNonNull(monster.m_21051_(Attributes.f_22279_)).m_22115_();
        double health = Objects.requireNonNull(monster.m_21051_(Attributes.f_22276_)).m_22115_();
        Objects.requireNonNull(monster.m_21051_(Attributes.f_22279_)).m_22100_(speed * this.speedMultiplier);
        Objects.requireNonNull(monster.m_21051_(Attributes.f_22276_)).m_22100_(health * this.healthMultiplier);
        monster.m_21153_((float)(health * this.healthMultiplier));
        monster.m_6593_((Component)this.mobClassName(monster));
        CompoundTag comp = monster.getPersistentData();
        CompoundTag type = new CompoundTag();
        type.m_128359_("variant", this.unlocalizedName);
        comp.m_128365_("challenger_mob_data", (Tag)type);
        monster.m_7292_(new MobEffectInstance(MobEffects.f_19607_, Integer.MAX_VALUE, 1, false, false));
    }

    private MutableComponent mobClassName(Monster mob) {
        TranslatableContents c = new TranslatableContents("vtweaks." + this.unlocalizedName + ".challenger.mob", "Challenger Mob", new Object[]{mob.m_7755_()});
        try {
            return c.m_213698_(null, (Entity)mob, 0);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return Component.m_237119_().m_130946_(e.getMessage());
        }
    }

    @Nullable
    public ItemStack pickLoot() {
        ItemStack loot = this.loot.pick();
        return loot == null ? null : loot.m_41777_();
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public Vector3f getParticleColor() {
        return this.particleColor;
    }

    public int getWeight() {
        return this.weight;
    }

    public List<MobEffectInstance> getAttackEffects() {
        return this.effectsOnAttack;
    }

    public List<ResourceLocation> getEntityFilter() {
        return this.entityFilter;
    }

    public boolean isEntityFilterIsBlacklist() {
        return this.entityFilterIsBlacklist;
    }
}

