/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.helpers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.util.WeightedCollection;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class VTJsonHelpers {
    public static ItemStack deserializeItemStack(JsonObject parent, String key) {
        if (parent.has(key)) {
            try {
                return ShapedRecipe.m_151274_((JsonObject)parent.getAsJsonObject(key));
            }
            catch (JsonSyntaxException ex) {
                VTweaks.getInstance().LOGGER.error("Item {} does not exist", (Object)parent.get(key).toString());
                ex.printStackTrace();
                return ItemStack.f_41583_;
            }
        }
        return ItemStack.f_41583_;
    }

    public static ArrayList<MobEffectInstance> deserializeEffectInstanceList(JsonArray arr) {
        ArrayList<MobEffectInstance> effs = new ArrayList<MobEffectInstance>();
        for (JsonElement jsonElement : arr) {
            MobEffectInstance ins = VTJsonHelpers.deserializeEffectInstance(jsonElement.getAsJsonObject());
            if (ins == null) continue;
            effs.add(ins);
        }
        return effs;
    }

    @Nullable
    public static MobEffectInstance deserializeEffectInstance(JsonObject json) {
        try {
            String name = json.get("name").getAsString();
            int amplifier = json.has("amplifier") ? json.get("amplifier").getAsInt() : 0;
            int duration = json.has("duration") ? json.get("duration").getAsInt() : 100;
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(name));
            if (effect == null) {
                VTweaks.getInstance().LOGGER.info("Effect {} is not a valid effect", (Object)name);
                return null;
            }
            return new MobEffectInstance(effect, duration, amplifier);
        }
        catch (NullPointerException ex) {
            VTweaks.getInstance().LOGGER.error("Received invalid effect: {}", (Object)json);
            VTweaks.getInstance().LOGGER.error((Object)ex);
            return null;
        }
    }

    @Nonnull
    public static WeightedCollection<ItemStack> deserializeLootTable(JsonArray table) {
        WeightedCollection<ItemStack> loot = new WeightedCollection<ItemStack>();
        for (JsonElement jsonElement : table) {
            JsonObject obj = jsonElement.getAsJsonObject();
            int chance = obj.get("weight").getAsInt();
            ItemStack item = VTJsonHelpers.deserializeItemStack(obj, "item");
            loot.add(item, chance);
        }
        return loot;
    }
}

