/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.FilterGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.RegistryObject;

public class ConveyorDroppingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape BB = Shapes.m_83048_((double)0.1875, (double)0.0625, (double)0.1875, (double)0.8125, (double)0.063125, (double)0.8125);
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;

    public ConveyorDroppingUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public void handleEntity(Entity entity) {
        BlockEntity tile;
        super.handleEntity(entity);
        if (entity instanceof Player) {
            return;
        }
        if (this.whitelist != this.filter.matches(entity)) {
            return;
        }
        if (entity instanceof ItemEntity && (tile = this.getWorld().m_7702_(this.getPos().m_121945_(Direction.DOWN))) != null) {
            tile.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(handler -> {
                if (this.getBoundingBox().m_83215_().m_82338_(this.getPos()).m_82400_(0.01).m_82381_(entity.m_20191_())) {
                    ItemStack stack = ((ItemEntity)entity).m_32055_();
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if ((stack = handler.insertItem(i, stack, false)).m_41619_()) {
                            entity.m_142687_(Entity.RemovalReason.KILLED);
                            break;
                        }
                        ((ItemEntity)entity).m_32045_(stack);
                    }
                }
            });
        }
        if (!entity.m_6084_()) {
            return;
        }
        double entityHeight = entity.m_20191_().f_82292_ - entity.m_20191_().f_82289_;
        BlockPos pos = this.getPos().m_6625_((int)Math.ceil(entityHeight));
        boolean space = true;
        for (int y = pos.m_123342_(); y < this.getPos().m_123342_(); ++y) {
            if (this.getWorld().m_46859_(new BlockPos(pos.m_123341_(), y, pos.m_123343_()))) continue;
            space = false;
            break;
        }
        if (space) {
            entity.m_20334_(0.0, 0.0, 0.0);
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.1, (double)pos.m_123343_() + 0.5);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT() == null ? new CompoundTag() : super.serializeNBT();
        compound.m_128365_("Filter", (Tag)this.filter.serializeNBT());
        compound.m_128379_("Whitelist", this.whitelist);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (nbt.m_128441_("Filter")) {
            this.filter.deserializeNBT(nbt.m_128469_("Filter"));
        }
        this.whitelist = nbt.m_128471_("Whitelist");
    }

    @Override
    public VoxelShape getBoundingBox() {
        return BB;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundTag compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.m_41712_((CompoundTag)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorDroppingUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorDroppingUpgrade.this.whitelist ? 0 : 1;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            super("dropping");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorDroppingUpgrade(container, this, face);
        }

        @Override
        public Set<ResourceLocation> getTextures() {
            return Collections.singleton(new ResourceLocation("industrialforegoing", "block/conveyor_dropping_upgrade"));
        }

        @Override
        @Nonnull
        public Set<Direction> getValidFacings() {
            return DOWN;
        }

        @Override
        public Direction getSideForPlacement(Level world, BlockPos pos, Player player) {
            return Direction.DOWN;
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_dropping");
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_dropping_upgrade");
        }

        public void registerRecipe(Consumer<FinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this.getUpgradeItem()).m_126130_("IPI").m_126130_("IDI").m_126130_("ICI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)Blocks.f_50183_).m_126127_(Character.valueOf('D'), (ItemLike)Blocks.f_50286_).m_126127_(Character.valueOf('C'), (ItemLike)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get()).m_176498_(consumer);
        }
    }
}

