/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.handler;

import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.screens.inventory.IndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.inventory.ModsIndexViewScreen;
import fuzs.completionistsindex.config.ClientConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;

public class IndexButtonHandler {
    @Nullable
    private static AbstractWidget recipeBookButton;
    @Nullable
    private static AbstractWidget collectorsLogButton;

    public static void onScreenInit$Post$1(Minecraft minecraft, Screen screen, int screenWidth, int screenHeight, List<AbstractWidget> widgets, Consumer<AbstractWidget> addWidget, Consumer<AbstractWidget> removeWidget) {
        if (!(screen instanceof InventoryScreen)) {
            return;
        }
        if (((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).indexButtonScreen == ClientConfig.IndexButtonScreen.PAUSE_MENU) {
            return;
        }
        recipeBookButton = IndexButtonHandler.findRecipeBookButton(widgets);
        if (recipeBookButton == null) {
            return;
        }
        collectorsLogButton = new ImageButton(recipeBookButton.m_252754_() + recipeBookButton.m_5711_() + 8, recipeBookButton.m_252907_(), 20, 18, 100, 198, 18, IndexViewScreen.INDEX_LOCATION, 512, 256, button -> minecraft.m_91152_((Screen)new ModsIndexViewScreen(screen)));
        addWidget.accept(collectorsLogButton);
    }

    @Nullable
    private static AbstractWidget findRecipeBookButton(List<AbstractWidget> widgets) {
        for (AbstractWidget widget : widgets) {
            if (!(widget instanceof ImageButton)) continue;
            ImageButton imageButton = (ImageButton)widget;
            return imageButton;
        }
        return null;
    }

    public static void onMouseClicked$Post(Screen screen, double mouseX, double mouseY, int button) {
        if (collectorsLogButton != null && recipeBookButton != null) {
            collectorsLogButton.m_252865_(recipeBookButton.m_252754_() + recipeBookButton.m_5711_() + 8);
            collectorsLogButton.m_253211_(recipeBookButton.m_252907_());
        }
    }

    public static void onScreenInit$Post$2(Minecraft minecraft, Screen screen, int screenWidth, int screenHeight, List<AbstractWidget> widgets, Consumer<AbstractWidget> addWidget, Consumer<AbstractWidget> removeWidget) {
        String[] vanillaButtons;
        if (!(screen instanceof PauseScreen)) {
            return;
        }
        if (((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).indexButtonScreen == ClientConfig.IndexButtonScreen.INVENTORY_MENU) {
            return;
        }
        int buttonX = screenWidth / 2 + 4 + 98 + 4;
        int buttonY = screenHeight / 4 + 48 + -16;
        for (String buttonKey : vanillaButtons = new String[]{"gui.stats", "menu.returnToGame", "menu.reportBugs", "menu.shareToLan"}) {
            Optional<Button> menuButton = IndexButtonHandler.getButton(widgets, buttonKey);
            if (!menuButton.isPresent()) continue;
            Button otherButton = menuButton.get();
            buttonX = otherButton.m_252754_() + otherButton.m_5711_() + 4;
            buttonY = otherButton.m_252907_();
            break;
        }
        addWidget.accept((AbstractWidget)new ImageButton(buttonX, buttonY, 20, 20, 80, 198, 20, IndexViewScreen.INDEX_LOCATION, 512, 256, button -> minecraft.m_91152_((Screen)new ModsIndexViewScreen(screen))));
    }

    private static Optional<Button> getButton(List<AbstractWidget> widgets, String translationKey) {
        for (AbstractWidget widget : widgets) {
            Button button;
            if (!(widget instanceof Button) || !IndexButtonHandler.matchesTranslationKey(button = (Button)widget, translationKey)) continue;
            return Optional.of(button);
        }
        return Optional.empty();
    }

    private static boolean matchesTranslationKey(Button button, String translationKey) {
        TranslatableContents contents;
        ComponentContents componentContents = button.m_6035_().m_214077_();
        return componentContents instanceof TranslatableContents && (contents = (TranslatableContents)componentContents).m_237508_().equals(translationKey);
    }
}

