/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.inventory;

import com.google.common.collect.Maps;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.screens.inventory.IndexViewScreen;
import fuzs.completionistsindex.config.ClientConfig;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;

public class ModsIndexViewScreen
extends IndexViewScreen
implements StatsUpdateListener {
    private static final Component DOWNLOAD_PENDING_COMPONENT = Component.m_237115_((String)"multiplayer.downloadingStats");
    public static final String ALL_ITEMS_PLACEHOLDER = "__ALL__";
    private final Map<String, List<ItemStack>> allItemsByMod = ModsIndexViewScreen.getAllItemsByMod();
    private boolean isLoading = true;

    public ModsIndexViewScreen(Screen lastScreen) {
        super(lastScreen);
    }

    private static Map<String, List<ItemStack>> getAllItemsByMod() {
        Minecraft minecraft = Minecraft.m_91087_();
        CreativeModeTabs.m_269226_((FeatureFlagSet)minecraft.f_91074_.f_108617_.m_247016_(), (boolean)false, (HolderLookup.Provider)minecraft.f_91073_.m_9598_());
        Collection displayItems = CreativeModeTabs.m_258007_().m_260957_();
        List items = displayItems.stream().map(ItemStack::m_41720_).distinct().filter(Predicate.not(arg_0 -> ((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).blacklist.contains(arg_0))).map(ItemStack::new).collect(Collectors.toList());
        Map displayItemsByMod = items.stream().collect(Collectors.groupingBy(item -> BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).m_135827_(), Maps::newLinkedHashMap, Collectors.toList()));
        if (displayItemsByMod.size() > 1) {
            displayItemsByMod.put(ALL_ITEMS_PLACEHOLDER, items);
        }
        return displayItemsByMod;
    }

    public void m_7819_() {
        if (this.isLoading) {
            this.isLoading = false;
            this.rebuildPages();
        }
    }

    @Override
    protected void rebuildPages() {
        if (!this.isLoading) {
            super.rebuildPages();
        }
    }

    @Override
    protected List<IndexViewScreen.IndexViewPage.Entry> getPageEntries() {
        StatsCounter stats = this.f_96541_.f_91074_.m_108630_();
        return this.allItemsByMod.entrySet().stream().map(entry -> IndexViewScreen.IndexViewPage.modItemEntry((String)entry.getKey(), (List)entry.getValue(), stats, this.f_96547_)).sorted(this.getComparator()).toList();
    }

    @Override
    protected void m_7856_() {
        this.isLoading = true;
        this.f_96541_.m_91403_().m_104955_((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
        super.m_7856_();
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, tickDelta);
        if (this.isLoading) {
            guiGraphics.m_280614_(this.f_96547_, DOWNLOAD_PENDING_COMPONENT, (this.f_96543_ - this.f_96547_.m_92852_((FormattedText)DOWNLOAD_PENDING_COMPONENT)) / 2, this.topPos + 99 - 18, 0, false);
            MutableComponent component = Component.m_237113_((String)f_97124_[(int)(Util.m_137550_() / 150L % (long)f_97124_.length)]);
            guiGraphics.m_280614_(this.f_96547_, (Component)component, (this.f_96543_ - this.f_96547_.m_92852_((FormattedText)component)) / 2, this.topPos + 99, 0, false);
        }
    }
}

