/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarytabs.config;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import sfiomn.legendarytabs.LegendaryTabs;

public class Config {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    public static void register(FMLJavaModLoadingContext context) {
        Path configPath = LegendaryTabs.modConfigPath;
        try {
            Files.createDirectory(configPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LegendaryTabs.LOGGER.error("Failed to create Legendary Tabs config directory " + configPath);
            e.printStackTrace();
        }
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC, "legendarytabs/legendarytabs-client.toml");
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue inventoryTabEnabled;
        public final ForgeConfigSpec.BooleanValue backpackTabEnabled;
        public final ForgeConfigSpec.BooleanValue travelersBackpackTabEnabled;
        public final ForgeConfigSpec.BooleanValue bodyDamageTabEnabled;
        public final ForgeConfigSpec.BooleanValue reskillableTabEnabled;
        public final ForgeConfigSpec.BooleanValue ftbQuestsTabEnabled;
        public final ForgeConfigSpec.BooleanValue mapAtlasesTabEnabled;
        public final ForgeConfigSpec.BooleanValue xaerosMapTabEnabled;
        public final ForgeConfigSpec.BooleanValue journeyMapTabEnabled;
        public final ForgeConfigSpec.BooleanValue ftbTeamsTabEnabled;
        public final ForgeConfigSpec.BooleanValue dietTabEnabled;
        public final ForgeConfigSpec.BooleanValue pufferfishSkillsTabEnabled;
        public final ForgeConfigSpec.BooleanValue passiveSkillTreeTabEnabled;
        public final ForgeConfigSpec.IntValue tabsMenuOffsetX;
        public final ForgeConfigSpec.IntValue tabsMenuOffsetY;
        public final ForgeConfigSpec.BooleanValue includeOpenedScreenTab;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("tabs-menu").comment(" Configuration about the new tabs added on top of defined screens");
            this.tabsMenuOffsetX = builder.comment(new String[]{" The X and Y offset of the tabs menu. Set both to 0 for no offset.", " By default, will be rendered above minecraft menus. Set it to 10000 to disable it completely."}).defineInRange("Tabs Menu Display X Offset", 2, -10000, 10000);
            this.tabsMenuOffsetY = builder.defineInRange("Tabs Menu Display Y Offset", 0, -10000, 10000);
            this.includeOpenedScreenTab = builder.comment(" If enabled, show current tab opened in the tabs menu.").define("Include Opened Screen Tab", true);
            this.inventoryTabEnabled = builder.comment(" If enabled, show the inventory button in the tabs menu.").define("Inventory Tab Enabled ", true);
            this.backpackTabEnabled = builder.comment(" If enabled, show the backpack button for Backpacked mod in the tabs menu.").define("Backpacked Tab Enabled ", true);
            this.travelersBackpackTabEnabled = builder.comment(" If enabled, show the backpack button for Travelers Backpack mod in the tabs menu.").define("Travelers Backpack Tab Enabled ", true);
            this.bodyDamageTabEnabled = builder.comment(" If enabled, show the body damage button for Legendarysurvivaloverhaul in the tabs menu.").define("Body Damage Tab Enabled ", true);
            this.reskillableTabEnabled = builder.comment(" If enabled, show the reskillable button for Rereskillable or Reskillable Reimagined in the tabs menu.").define("Reskillable Tab Enabled ", true);
            this.ftbQuestsTabEnabled = builder.comment(" If enabled, show the ftb quests button in the tabs menu.").define("FTB Quests Tab Enabled ", true);
            this.mapAtlasesTabEnabled = builder.comment(" If enabled, show the map button for Map Atlases mod in the tabs menu.").define("Map Atlases Tab Enabled ", true);
            this.xaerosMapTabEnabled = builder.comment(" If enabled, show the map button for Xaero's Map mod in the tabs menu.").define("Xaero's Map Tab Enabled ", true);
            this.journeyMapTabEnabled = builder.comment(" If enabled, show the map button for Journey Map mod in the tabs menu.").define("Journey Map Tab Enabled ", true);
            this.ftbTeamsTabEnabled = builder.comment(" If enabled, show the ftb teams button in the tabs menu.").define("FTB Teams Tab Enabled ", true);
            this.dietTabEnabled = builder.comment(" If enabled, show the diet button in the tabs menu.").define("Diet Tab Enabled ", true);
            this.pufferfishSkillsTabEnabled = builder.comment(" If enabled, show the pufferfish's skills button in the tabs menu.").define("Pufferfish Skills Tab Enabled ", true);
            this.passiveSkillTreeTabEnabled = builder.comment(" If enabled, show the passive skill tree button in the tabs menu.").define("Passive Skill Tree Tab Enabled ", true);
            builder.pop();
        }
    }

    public static class Baked {
        public static boolean includeOpenedScreenTab;
        public static int tabsMenuOffsetX;
        public static int tabsMenuOffsetY;
        public static boolean inventoryTabEnabled;
        public static boolean backpackTabEnabled;
        public static boolean travelersBackpackTabEnabled;
        public static boolean mapAtlasesTabEnabled;
        public static boolean xaerosMapTabEnabled;
        public static boolean journeyMapTabEnabled;
        public static boolean bodyDamageTabEnabled;
        public static boolean reskillableTabEnabled;
        public static boolean ftbQuestsTabEnabled;
        public static boolean ftbTeamsTabEnabled;
        public static boolean dietTabEnabled;
        public static boolean pufferfishSkillsTabEnabled;
        public static boolean passiveSkillTreeTabEnabled;

        public static void bakeClient() {
            LegendaryTabs.LOGGER.debug("Load Client configuration from file");
            try {
                includeOpenedScreenTab = (Boolean)Config.CLIENT.includeOpenedScreenTab.get();
                tabsMenuOffsetX = (Integer)Config.CLIENT.tabsMenuOffsetX.get();
                tabsMenuOffsetY = (Integer)Config.CLIENT.tabsMenuOffsetY.get();
                inventoryTabEnabled = (Boolean)Config.CLIENT.inventoryTabEnabled.get();
                backpackTabEnabled = (Boolean)Config.CLIENT.backpackTabEnabled.get();
                travelersBackpackTabEnabled = (Boolean)Config.CLIENT.travelersBackpackTabEnabled.get();
                bodyDamageTabEnabled = (Boolean)Config.CLIENT.bodyDamageTabEnabled.get();
                reskillableTabEnabled = (Boolean)Config.CLIENT.reskillableTabEnabled.get();
                ftbQuestsTabEnabled = (Boolean)Config.CLIENT.ftbQuestsTabEnabled.get();
                mapAtlasesTabEnabled = (Boolean)Config.CLIENT.mapAtlasesTabEnabled.get();
                xaerosMapTabEnabled = (Boolean)Config.CLIENT.xaerosMapTabEnabled.get();
                journeyMapTabEnabled = (Boolean)Config.CLIENT.journeyMapTabEnabled.get();
                ftbTeamsTabEnabled = (Boolean)Config.CLIENT.ftbTeamsTabEnabled.get();
                dietTabEnabled = (Boolean)Config.CLIENT.dietTabEnabled.get();
                pufferfishSkillsTabEnabled = (Boolean)Config.CLIENT.pufferfishSkillsTabEnabled.get();
                passiveSkillTreeTabEnabled = (Boolean)Config.CLIENT.passiveSkillTreeTabEnabled.get();
            }
            catch (Exception e) {
                LegendaryTabs.LOGGER.warn("An exception was caused trying to load the client config for Legendary Survival Overhaul.");
                e.printStackTrace();
            }
        }
    }

    public static class Server {
        Server(ForgeConfigSpec.Builder builder) {
        }
    }
}

