/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.mixin.common.minecolonies;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.core.datalistener.ResearchListener;
import com.minecolonies.core.research.GlobalResearch;
import com.minecolonies.core.research.ResearchEffectCategory;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_tweaks.core.common.research.GlobalResearchEffectExtension;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchEffectCategoryExtension;

@Mixin(value={ResearchListener.class}, remap=false)
public abstract class ResearchListenerMixin {
    private static final String RESEARCH_COMMAND_PROP = "command";
    private static final String RESEARCH_OFFLINE_RUNNABLE_PROP = "offlineRunnable";

    @Inject(method={"parseResearches"}, remap=false, at={@At(value="TAIL")}, cancellable=false)
    private void parseResearches(Map<ResourceLocation, JsonElement> object, Map<ResourceLocation, ResearchEffectCategory> effectCategories, Collection<ResourceLocation> removeResearches, Collection<ResourceLocation> removeBranches, CallbackInfoReturnable<Map<ResourceLocation, GlobalResearch>> cir) {
        Map map = (Map)cir.getReturnValue();
        for (Map.Entry entry : map.entrySet()) {
            GlobalResearch research = (GlobalResearch)entry.getValue();
            for (IResearchEffect effect : research.getEffects()) {
                if (!(effect instanceof GlobalResearchEffectExtension)) continue;
                GlobalResearchEffectExtension effectExtension = (GlobalResearchEffectExtension)effect;
                ResearchEffectCategory category = effectCategories.get(effect.getId());
                if (!(category instanceof ResearchEffectCategoryExtension)) continue;
                ResearchEffectCategoryExtension categoryExtension = (ResearchEffectCategoryExtension)category;
                effectExtension.minecolonies_tweaks$setCommand(categoryExtension.minecolonies_tweaks$getCommand());
                effectExtension.minecolonies_tweaks$setOfflineRunnable(categoryExtension.minecolonies_tweaks$isOfflineRunnable());
            }
        }
    }

    @Inject(method={"parseResearchEffectCategories"}, remap=false, at={@At(value="TAIL")}, cancellable=false)
    private void parseResearchEffectCategories(Map<ResourceLocation, JsonElement> object, CallbackInfoReturnable<Map<ResourceLocation, ResearchEffectCategory>> cir) {
        for (Map.Entry entry : ((Map)cir.getReturnValue()).entrySet()) {
            JsonObject json = object.get(entry.getKey()).getAsJsonObject();
            if (json.has(RESEARCH_COMMAND_PROP)) {
                String command = json.get(RESEARCH_COMMAND_PROP).getAsString();
                ((ResearchEffectCategoryExtension)entry.getValue()).minecolonies_tweaks$setCommand(command);
            }
            if (!json.has(RESEARCH_OFFLINE_RUNNABLE_PROP)) continue;
            boolean offlineRunnable = json.get(RESEARCH_OFFLINE_RUNNABLE_PROP).getAsBoolean();
            ((ResearchEffectCategoryExtension)entry.getValue()).minecolonies_tweaks$setOfflineRunnable(offlineRunnable);
        }
    }
}

