/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IItemListModuleView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_tweaks.core.common.network.message.BuildingModuleMessage;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public class AssignFilterableItemsMessage
extends BuildingModuleMessage {
    private final Function function;
    private final List<ItemStorage> storages;

    public AssignFilterableItemsMessage(IItemListModuleView module, Function function, Iterable<ItemStorage> storages) {
        super((IBuildingModuleView)module);
        this.function = function;
        this.storages = ImmutableList.copyOf(storages);
    }

    public AssignFilterableItemsMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.function = (Function)buffer.m_130066_(Function.class);
        this.storages = buffer.m_236845_(SerializationHelper.deserializer());
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130068_((Enum)this.function);
        buffer.m_236828_(this.storages, SerializationHelper.serializer());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        IBuildingModule iBuildingModule = this.getModulePos().getModule();
        if (iBuildingModule instanceof ItemListModule) {
            ItemListModule module = (ItemListModule)iBuildingModule;
            if (this.function == Function.ADD) {
                this.storages.forEach(arg_0 -> ((ItemListModule)module).addItem(arg_0));
            } else if (this.function == Function.REMOVE) {
                this.storages.forEach(arg_0 -> ((ItemListModule)module).removeItem(arg_0));
            }
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public List<ItemStorage> getStorages() {
        return this.storages;
    }

    public static enum Function {
        CLEAR,
        ADD,
        REMOVE;

    }
}

