/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.inventory;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksItems;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksMenuTypes;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksTags;
import steve_gall.minecolonies_tweaks.core.common.item.ItemResourceScrollBook;

public class ResourceScrollBookInventoryMenu
extends AbstractContainerMenu {
    private final Inventory inventory;
    private final int bookSlot;
    private final ItemResourceScrollBook.Container container;

    public static ResourceScrollBookInventoryMenu create(int windowId, Inventory inventory, FriendlyByteBuf extraData) {
        int bookSlot = extraData.readInt();
        return new ResourceScrollBookInventoryMenu(windowId, inventory, bookSlot);
    }

    public ResourceScrollBookInventoryMenu(int windowId, Inventory inventory, int bookSlot) {
        super((MenuType)MCTweaksMenuTypes.RESOURCESCROLL_BOOK_INVENTORY.get(), windowId);
        int xi;
        int i;
        this.inventory = inventory;
        this.bookSlot = bookSlot;
        this.container = ((ItemResourceScrollBook)((Object)MCTweaksItems.RESOURCESCROLL_BOOK.get())).getContainer(this.getBook());
        for (i = 0; i < this.container.m_6643_(); ++i) {
            xi = i % 9;
            int yi = i / 9;
            this.m_38897_(new BookSlot(this.container, i, 8 + xi * 18, 18 + yi * 18));
        }
        i = ((this.container.m_6643_() + 8) / 9 - 4) * 18;
        for (int yi = 0; yi < 3; ++yi) {
            for (int xi2 = 0; xi2 < 9; ++xi2) {
                int slot = xi2 + (yi + 1) * 9;
                this.m_38897_(new InventorySlot(inventory, slot, 8 + xi2 * 18, 103 + yi * 18 + i));
            }
        }
        for (xi = 0; xi < 9; ++xi) {
            int slot = xi;
            this.m_38897_(new InventorySlot(inventory, slot, 8 + xi * 18, 161 + i));
        }
    }

    public ItemStack getBook() {
        return this.inventory.m_8020_(this.getBookSlot());
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (slotIndex < this.container.m_6643_() ? !this.m_38903_(stack, this.container.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(stack, 0, this.container.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public ItemResourceScrollBook.Container getContainer() {
        return this.container;
    }

    public int getBookSlot() {
        return this.bookSlot;
    }

    public boolean m_6875_(Player player) {
        return this.getBook().m_150930_((Item)MCTweaksItems.RESOURCESCROLL_BOOK.get());
    }

    public class BookSlot
    extends Slot {
        public BookSlot(ItemResourceScrollBook.Container container, int slot, int x, int y) {
            super((Container)container, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_204117_(MCTweaksTags.Items.RESOURCESCROLLBOOK_ELEMENT);
        }
    }

    public class InventorySlot
    extends Slot {
        public InventorySlot(Inventory inventory, int slot, int x, int y) {
            super((Container)inventory, slot, x, y);
        }

        public boolean m_8010_(Player player) {
            return this.getSlotIndex() != ResourceScrollBookInventoryMenu.this.getBookSlot();
        }
    }
}

