/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.view;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.util.SpacerTextComponent;
import com.ldtteam.blockui.util.ToggleableTextComponent;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.core.client.gui.RenderUtils;

public class FluidIcon
extends Pane {
    protected static final float DEFAULT_ITEMSTACK_SIZE = 16.0f;
    protected static final MutableComponent FIX_VANILLA_TOOLTIP = SpacerTextComponent.of((int)1);
    @Nullable
    protected FluidStack fluidStack;
    protected boolean tooltipUpdateScheduled = false;
    protected boolean showAmount = true;

    public FluidIcon() {
    }

    public FluidIcon(PaneParams params) {
        super(params);
        Fluid fluid;
        String fluidName = params.getString("fluid");
        if (fluidName != null && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName))) != null) {
            int fluidAmount = params.getInteger("amount", 1);
            this.setFluid(new FluidStack(fluid, fluidAmount));
        }
        this.showAmount = params.getBoolean("showAmount", this.showAmount);
    }

    public void setFluid(FluidStack fluidStack) {
        this.clearDataAndScheduleTooltipUpdate();
        this.fluidStack = fluidStack;
        this.onFluidUpdate();
    }

    protected void onFluidUpdate() {
    }

    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public void setShowAmount(boolean showAmount) {
        this.showAmount = showAmount;
    }

    public boolean showAmount() {
        return this.showAmount;
    }

    public void clearDataAndScheduleTooltipUpdate() {
        this.fluidStack = null;
        this.tooltipUpdateScheduled = true;
    }

    protected boolean isFluidEmpty() {
        return this.fluidStack == null || this.fluidStack.isEmpty();
    }

    public boolean isDataEmpty() {
        return this.isFluidEmpty();
    }

    protected void updateTooltipIfNeeded() {
        if (this.tooltipUpdateScheduled) {
            Pane pane = this.onHover;
            if (pane instanceof Tooltip.AutomaticTooltip) {
                Tooltip.AutomaticTooltip tooltip = (Tooltip.AutomaticTooltip)pane;
                tooltip.setTextOld(this.getModifiedFluidStackTooltip());
            }
            this.tooltipUpdateScheduled = false;
        }
    }

    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        this.updateTooltipIfNeeded();
        if (!this.isDataEmpty()) {
            PoseStack ms = target.m_280168_();
            ms.m_85836_();
            ms.m_252880_((float)this.x, (float)this.y, 0.0f);
            RenderUtils.renderFluid(ms, 16, 16, this.fluidStack);
            ms.m_85849_();
        }
    }

    public void onUpdate() {
        if (this.onHover == null && !this.isFluidEmpty()) {
            new AbstractTextBuilder.AutomaticTooltipBuilder().hoverPane((Pane)this).build().setTextOld(this.getModifiedFluidStackTooltip());
        }
    }

    protected int modifyTooltipName(List<Component> tooltipList, TooltipFlag tooltipFlags, int nameOffset) {
        return nameOffset;
    }

    protected int appendTooltip(List<Component> tooltipList, TooltipFlag tooltipFlags, int prevTooltipSize) {
        return prevTooltipSize;
    }

    public List<Component> getModifiedFluidStackTooltip() {
        TooltipFlag.Default tooltipFlags;
        if (this.isDataEmpty()) {
            return Collections.emptyList();
        }
        TooltipFlag.Default default_ = tooltipFlags = this.mc.f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_;
        if (this.mc.f_91074_.m_7500_()) {
            tooltipFlags = tooltipFlags.m_257777_();
        }
        Fluid fluid = this.fluidStack.getFluid();
        ResourceLocation id = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        String namespace = id.m_135827_();
        int nameOffset = 1;
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        tooltipList.add(this.fluidStack.getDisplayName());
        if (tooltipFlags.m_7050_()) {
            tooltipList.add((Component)Component.m_237113_((String)id.toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (this.showAmount()) {
            tooltipList.add((Component)Component.m_237113_((String)(String.format("%,d", this.fluidStack.getAmount()) + " mB")).m_130940_(ChatFormatting.GRAY));
        }
        tooltipList.add((Component)Component.m_237113_((String)ModList.get().getModContainerById(namespace).map(f -> f.getModInfo().getDisplayName()).orElse(namespace)).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        nameOffset = this.modifyTooltipName(tooltipList, (TooltipFlag)tooltipFlags, nameOffset);
        int prevTooltipSize = tooltipList.size();
        if (tooltipFlags.m_7050_() && tooltipFlags.m_257552_()) {
            int c = nameOffset + 1;
            ForgeRegistries.FLUIDS.getHolder((Object)fluid).map(Holder::getTagKeys).ifPresent(tags -> tags.forEach(tag -> tooltipList.add(c, (Component)FluidIcon.wrapShift(Component.m_237113_((String)("#" + tag.f_203868_())).m_130940_(ChatFormatting.DARK_PURPLE)))));
        }
        if ((prevTooltipSize = this.appendTooltip(tooltipList, (TooltipFlag)tooltipFlags, prevTooltipSize)) != tooltipList.size()) {
            tooltipList.add((Component)ToggleableTextComponent.ofNegated(Screen::m_96638_, (MutableComponent)Component.m_237119_()));
            tooltipList.add((Component)ToggleableTextComponent.ofNegated(Screen::m_96638_, (MutableComponent)Component.m_237110_((String)"blockui.tooltip.item_additional_info", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.shift")}).m_130940_(ChatFormatting.GOLD)));
        }
        tooltipList.add(nameOffset, (Component)FIX_VANILLA_TOOLTIP);
        return tooltipList;
    }

    protected static MutableComponent wrapShift(MutableComponent wrapped) {
        return ToggleableTextComponent.of(Screen::m_96638_, (MutableComponent)wrapped);
    }

    protected static MutableComponent wrapShift(MutableComponent wrapped, boolean shouldWrap) {
        return shouldWrap ? ToggleableTextComponent.of(Screen::m_96638_, (MutableComponent)wrapped) : wrapped;
    }
}

