/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final int FLUID_TEXTURE_SIZE = 16;

    public static void renderFluid(PoseStack poseStack, int width, int height, FluidStack fluidStack) {
        RenderUtils.renderFluid(poseStack, width, height, fluidStack, fluidStack.getAmount());
    }

    public static void renderFluid(PoseStack poseStack, int width, int height, FluidStack fluidStack, int capacity) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return;
        }
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = renderProperties.getStillTexture(fluidStack);
        TextureAtlasSprite stillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
        if (stillSprite == null) {
            return;
        }
        int tintColor = renderProperties.getTintColor(fluidStack);
        double scachedHeight = (double)height * ((double)fluidStack.getAmount() / Math.max((double)capacity, 1.0));
        RenderUtils.renderTiledSprite(poseStack, width, height, tintColor, (int)scachedHeight, stillSprite);
    }

    public static void renderTiledSprite(PoseStack poseStack, int tiledWidth, int tiledHeight, int color, int scachedHeight, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderUtils.setShaderColor(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scachedHeight / 16;
        int yRemainder = scachedHeight - yTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int width = xTile == xTileCount ? xRemainder : 16;
                int n = height = yTile == yTileCount ? yRemainder : 16;
                if (width <= 0 || height <= 0) continue;
                int x = xTile * 16;
                int y = tiledHeight - (yTile + 1) * 16;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                RenderUtils.renderTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setShaderColor(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void renderTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, long maskRight, float zLevel) {
        float f = 16.0f;
        float u0 = textureSprite.m_118409_();
        float u1 = textureSprite.m_118410_();
        float v0 = textureSprite.m_118411_();
        float v1 = textureSprite.m_118412_();
        u1 -= (float)maskRight / f * (u1 - u0);
        v1 -= (float)maskTop / f * (v1 - v0);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + f, zLevel).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + f - (float)maskRight, yCoord + f, zLevel).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(u1, v0).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(u0, v0).m_5752_();
        tessellator.m_85914_();
    }

    private RenderUtils() {
    }
}

