/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;
import steve_gall.minecolonies_tweaks.api.common.tool.ToolTypeTags;

public class ToolTypeExtension {
    private static final Map<EquipmentTypeEntry, ToolTypeExtension> MAP = new HashMap<EquipmentTypeEntry, ToolTypeExtension>();
    @NotNull
    private final EquipmentTypeEntry toolType;
    @Nullable
    private final CustomToolType customToolType;
    private TagKey<Item> itemTag;
    private final Int2ObjectOpenHashMap<TagKey<Item>> levelTags;

    @NotNull
    public static ToolTypeExtension from(@NotNull EquipmentTypeEntry toolType) {
        return MAP.computeIfAbsent(toolType, ToolTypeExtension::new);
    }

    private ToolTypeExtension(@NotNull EquipmentTypeEntry toolType) {
        this.toolType = toolType;
        this.customToolType = CustomToolType.find(toolType.getRegistryName());
        this.levelTags = new Int2ObjectOpenHashMap();
    }

    private int getTagLevel(@NotNull ItemStack item) {
        for (int i = 0; i <= 5; ++i) {
            if (!item.m_204117_(this.getItemCustomLevelTag(i))) continue;
            return i;
        }
        return -1;
    }

    public int getCustomLevel(@NotNull ItemStack item) {
        int customLevel;
        int tagLevel = this.getTagLevel(item);
        if (tagLevel > -1) {
            return tagLevel;
        }
        CustomToolType custom = this.getCustomToolType();
        if (custom != null && (customLevel = custom.getToolLevel(item)) > -1) {
            return customLevel;
        }
        return -1;
    }

    public boolean isCustomTool(@NotNull ItemStack itemStack) {
        if (itemStack.m_204117_(this.getItemCustomTag())) {
            return true;
        }
        int tagLevel = this.getTagLevel(itemStack);
        if (tagLevel > -1) {
            return true;
        }
        CustomToolType custom = this.getCustomToolType();
        return custom != null && custom.isTool(itemStack);
    }

    @NotNull
    public EquipmentTypeEntry getToolType() {
        return this.toolType;
    }

    @Nullable
    public CustomToolType getCustomToolType() {
        return this.customToolType;
    }

    @NotNull
    public TagKey<Item> getItemCustomTag() {
        if (this.itemTag == null) {
            this.itemTag = ToolTypeTags.getCustomItem(this.getToolType().getRegistryName());
        }
        return this.itemTag;
    }

    @NotNull
    public TagKey<Item> getItemCustomLevelTag(int level) {
        return (TagKey)this.levelTags.computeIfAbsent(level, l -> ToolTypeTags.getCustomLevel(this.getToolType().getRegistryName(), l));
    }
}

