/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.tool.ConfigToolType;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolTypeRegisterEvent;
import steve_gall.minecolonies_tweaks.api.common.tool.ToolTypeTags;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public class CustomToolType {
    private static boolean INITIALIZED = false;
    private static final Map<ResourceLocation, CustomToolType> MAP = new HashMap<ResourceLocation, CustomToolType>();
    private static final List<CustomToolType> LIST = new ArrayList<CustomToolType>();
    @NotNull
    private final ResourceLocation name;
    @Nullable
    private Component displayName;
    @Nullable
    private Component tooltip;
    @Nullable
    private EquipmentTypeEntry toolType;

    public static void init() {
        if (INITIALIZED) {
            return;
        }
        INITIALIZED = true;
        try {
            Path path = FMLPaths.CONFIGDIR.get().resolve("minecolonies_tweaks-custom_tools.json");
            if (Files.exists(path, new LinkOption[0])) {
                Gson gson = new Gson();
                JsonArray raws = (JsonArray)gson.fromJson(Files.readString(path), JsonArray.class);
                for (JsonElement raw : raws) {
                    try {
                        JsonObject json = (JsonObject)gson.fromJson(raw, JsonObject.class);
                        ConfigToolType.Builder builder = new ConfigToolType.Builder(json);
                        CustomToolType.register(new ConfigToolType(builder, "minecolonies_tweaks"));
                    }
                    catch (Exception e) {
                        MineColoniesTweaks.LOGGER.error("Exception during load CustomToolType: " + raw, (Throwable)e);
                    }
                }
            } else {
                Files.writeString(path, (CharSequence)new JsonArray().toString(), new OpenOption[0]);
            }
        }
        catch (Exception e) {
            MineColoniesTweaks.LOGGER.error("Exception during load CustomToolType", (Throwable)e);
        }
        ModLoader.get().postEvent((Event)new CustomToolTypeRegisterEvent(CustomToolType::register));
    }

    private static void register(CustomToolType data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        ResourceLocation name = data.getName();
        CustomToolType prev = MAP.get(name);
        if (prev != null) {
            throw new IllegalArgumentException("Name '" + name + "' is already registered");
        }
        MAP.put(name, data);
        LIST.add(data);
        MineColoniesTweaks.LOGGER.info("CustomToolTypeData Added: " + name);
    }

    @NotNull
    public static Map<ResourceLocation, CustomToolType> map() {
        return Collections.unmodifiableMap(MAP);
    }

    @NotNull
    public static List<CustomToolType> list() {
        return Collections.unmodifiableList(LIST);
    }

    @Nullable
    public static CustomToolType find(@Nullable EquipmentTypeEntry toolType) {
        return toolType != null ? CustomToolType.find(toolType.getRegistryName()) : null;
    }

    @Nullable
    public static CustomToolType find(@NotNull ResourceLocation name) {
        return MAP.get(name);
    }

    public CustomToolType(@NotNull ResourceLocation name) {
        this.name = name;
    }

    @NotNull
    public static String getFallbackTranslationKey(@NotNull ResourceLocation name) {
        return "minecolonies_tweaks.custom_tooltype." + ToolTypeTags.getTagPath(name).replace('/', '.');
    }

    @NotNull
    public final ResourceLocation getName() {
        return this.name;
    }

    public String getDefaultDisplayNameTranslationKey() {
        return CustomToolType.getFallbackTranslationKey(this.getName());
    }

    protected Component createDisplayName() {
        return Component.m_237115_((String)this.getDefaultDisplayNameTranslationKey());
    }

    @NotNull
    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.createDisplayName();
        }
        return this.displayName;
    }

    public String getDefaultTooltipTranslationKey() {
        return this.getDefaultDisplayNameTranslationKey() + ".desc";
    }

    protected Component createTooltip() {
        return Component.m_237115_((String)this.getDefaultTooltipTranslationKey());
    }

    @NotNull
    public Component getTooltip() {
        if (this.tooltip == null) {
            this.tooltip = this.createTooltip();
        }
        return this.tooltip;
    }

    public final void pair(@NotNull EquipmentTypeEntry toolType) {
        if (this.toolType != null) {
            throw new IllegalCallerException("Already paired");
        }
        if (toolType == null) {
            throw new NullPointerException("toolType");
        }
        this.toolType = toolType;
    }

    @NotNull
    public final EquipmentTypeEntry getToolType() {
        if (this.toolType == null) {
            throw new IllegalCallerException("Not paired");
        }
        return this.toolType;
    }

    public int getToolLevel(@NotNull ItemStack stack) {
        return -1;
    }

    public boolean isTool(@NotNull ItemStack stack) {
        return false;
    }
}

