/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import com.google.gson.JsonObject;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;
import steve_gall.minecolonies_tweaks.core.common.util.GsonHelper2;

public class ConfigToolType
extends CustomToolType {
    @NotNull
    private final AutoLevelType autoLevelType;
    @NotNull
    private final String translationKey;
    @NotNull
    private final String tooltipKey;
    @NotNull
    private final int defaultLevel;
    @NotNull
    private final int durabilityBase;

    public ConfigToolType(Builder builder, String namespace) {
        super(new ResourceLocation(namespace, builder.name));
        this.autoLevelType = builder.autoLevelType;
        this.translationKey = builder.translationKey.orElseGet(() -> ConfigToolType.getFallbackTranslationKey(this.getName()));
        this.tooltipKey = builder.tooltipKey.orElseGet(() -> this.translationKey + ".desc");
        this.defaultLevel = builder.defaultLevel;
        this.durabilityBase = builder.durabilityBase;
    }

    @NotNull
    public AutoLevelType getAutoLevelType() {
        return this.autoLevelType;
    }

    public int getDurabilityBase() {
        return this.durabilityBase;
    }

    @Override
    public String getDefaultDisplayNameTranslationKey() {
        return this.translationKey;
    }

    @Override
    public String getDefaultTooltipTranslationKey() {
        return this.tooltipKey;
    }

    @Override
    public boolean isTool(@NotNull ItemStack stack) {
        return super.isTool(stack);
    }

    @Override
    public int getToolLevel(@NotNull ItemStack stack) {
        AutoLevelType autoLevelType = this.getAutoLevelType();
        int level = autoLevelType.getToolLevel(stack, this);
        if (level > -1) {
            return level;
        }
        if (this.defaultLevel > -1) {
            return this.defaultLevel;
        }
        return super.getToolLevel(stack);
    }

    public static class Builder {
        @NotNull
        private final String name;
        @NotNull
        private AutoLevelType autoLevelType = AutoLevelType.NONE;
        @NotNull
        private Optional<String> translationKey = Optional.empty();
        @NotNull
        private Optional<String> tooltipKey = Optional.empty();
        private int defaultLevel = 0;
        private int durabilityBase = 0;

        public Builder(@NotNull String name) {
            this.name = name;
        }

        public Builder(@NotNull ConfigToolType data) {
            this.name = data.getName().m_135815_();
            this.autoLevelType = data.autoLevelType;
            this.translationKey = Optional.of(data.translationKey);
            this.tooltipKey = Optional.of(data.tooltipKey);
            this.defaultLevel = data.defaultLevel;
            this.durabilityBase = data.durabilityBase;
        }

        public Builder(@NotNull JsonObject json) {
            this.name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            this.autoLevelType = AutoLevelType.valueOf(GsonHelper.m_13851_((JsonObject)json, (String)"autoLevelType", (String)AutoLevelType.NONE.name()));
            this.translationKey = GsonHelper2.of(json, "translationKey", GsonHelper::m_13906_);
            this.tooltipKey = GsonHelper2.of(json, "tooltipKey", GsonHelper::m_13906_);
            this.defaultLevel = GsonHelper.m_13824_((JsonObject)json, (String)"defaultLevel", (int)-1);
            this.durabilityBase = GsonHelper.m_13824_((JsonObject)json, (String)"durabilityBase", (int)Integer.MAX_VALUE);
        }

        @NotNull
        public JsonObject toObject() {
            JsonObject json = new JsonObject();
            json.addProperty("name", this.name());
            json.addProperty("autoLevelType", this.autoLevelType().name());
            GsonHelper2.ifPresent("translationKey", this.translationKey(), (arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            GsonHelper2.ifPresent("tooltipKey", this.tooltipKey(), (arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            json.addProperty("defaultLevel", (Number)this.defaultLevel());
            json.addProperty("durabilityBase", (Number)this.durabilityBase());
            return json;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public AutoLevelType autoLevelType() {
            return this.autoLevelType;
        }

        @NotNull
        public Builder autoLevelType(@NotNull AutoLevelType autoLevelType) {
            this.autoLevelType = autoLevelType;
            return this;
        }

        @NotNull
        public Optional<String> translationKey() {
            return this.translationKey;
        }

        @NotNull
        public Builder translationKey(@NotNull Optional<String> translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        @NotNull
        public Optional<String> tooltipKey() {
            return this.tooltipKey;
        }

        @NotNull
        public Builder tooltipKey(@NotNull Optional<String> tooltipKey) {
            this.tooltipKey = tooltipKey;
            return this;
        }

        @NotNull
        public int defaultLevel() {
            return this.defaultLevel;
        }

        @NotNull
        public Builder defaultLevel(int defaultLevel) {
            this.defaultLevel = defaultLevel;
            return this;
        }

        public int durabilityBase() {
            return this.durabilityBase;
        }

        @NotNull
        public Builder durabilityBase(int durabilityBase) {
            this.durabilityBase = durabilityBase;
            return this;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AutoLevelType {
        NONE{

            @Override
            public int getToolLevel(@NotNull ItemStack stack, @NotNull ConfigToolType toolType) {
                return -1;
            }
        }
        ,
        VANILLA_ARMOR{

            @Override
            public int getToolLevel(@NotNull ItemStack stack, @NotNull ConfigToolType toolType) {
                return ItemStackUtils.getArmorLevel((ItemStack)stack);
            }
        }
        ,
        VANILLA_TOOL{

            @Override
            public int getToolLevel(@NotNull ItemStack stack, @NotNull ConfigToolType toolType) {
                return ModEquipmentTypes.vanillaToolLevel((ItemStack)stack, (EquipmentTypeEntry)toolType.getToolType());
            }
        }
        ,
        DURABILITY_BASE{

            @Override
            public int getToolLevel(@NotNull ItemStack stack, @NotNull ConfigToolType toolType) {
                return ModEquipmentTypes.durabilityBasedLevel((ItemStack)stack, (int)toolType.getDurabilityBase());
            }
        };


        public int getToolLevel(@NotNull ItemStack stack, @NotNull ConfigToolType toolType) {
            return -1;
        }
    }
}

