/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.requestsystem.resolvers;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.resolvers.ICustomizableRequestResolver;

public class CustomizableRequestResolverFactory<RESOLVER extends ICustomizableRequestResolver<?>>
implements IRequestResolverFactory<RESOLVER> {
    private final TypeToken<RESOLVER> outputType;
    private final short serializationId;
    private final Serializer<RESOLVER> serializer;
    private final Deserializer<RESOLVER> deserializer;

    public CustomizableRequestResolverFactory(@NotNull Class<RESOLVER> clazz, short serializationId, @NotNull Serializer<RESOLVER> serializer, @NotNull Deserializer<RESOLVER> deserializer) {
        this.outputType = TypeToken.of(clazz);
        this.serializationId = serializationId;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @NotNull
    public TypeToken<RESOLVER> getFactoryOutputType() {
        return this.outputType;
    }

    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    public short getSerializationId() {
        return this.serializationId;
    }

    @NotNull
    public RESOLVER getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation input, Object ... context) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull RESOLVER output) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("location", (Tag)controller.serialize((Object)output.getLocation()));
        tag.m_128365_("token", (Tag)controller.serialize((Object)output.getId()));
        CompoundTag impl = new CompoundTag();
        this.serializer.serialize(output, impl);
        tag.m_128365_("impl", (Tag)impl);
        return tag;
    }

    @NotNull
    public RESOLVER deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag tag) throws Throwable {
        ILocation location = (ILocation)controller.deserialize(tag.m_128469_("location"));
        IToken token = (IToken)controller.deserialize(tag.m_128469_("token"));
        return this.deserializer.deserialze(location, token, tag.m_128469_("impl"));
    }

    public void serialize(@NotNull IFactoryController controller, @NotNull RESOLVER output, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(this.serialize(controller, output));
    }

    @NotNull
    public RESOLVER deserialize(@NotNull IFactoryController controller, @NotNull FriendlyByteBuf buffer) throws Throwable {
        return (RESOLVER)this.deserialize(controller, buffer.m_130260_());
    }

    @FunctionalInterface
    public static interface Serializer<RESOLVER extends ICustomizableRequestResolver<?>> {
        public void serialize(@NotNull RESOLVER var1, @NotNull CompoundTag var2);
    }

    @FunctionalInterface
    public static interface Deserializer<RESOLVER extends ICustomizableRequestResolver<?>> {
        public RESOLVER deserialze(@NotNull ILocation var1, @NotNull IToken<?> var2, @NotNull CompoundTag var3);
    }
}

