/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingPos {
    public static final String TAG_DIMENSION_ID = "dimensionId";
    public static final String TAG_COLONY_ID = "colonyId";
    public static final String TAG_BUILDING_ID = "buildingId";
    public static final Codec<BuildingPos> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Level.f_46427_.fieldOf(TAG_DIMENSION_ID).forGetter(BuildingPos::getDimensionId), (App)Codec.INT.fieldOf(TAG_COLONY_ID).forGetter(BuildingPos::getColonyId), (App)BlockPos.f_121852_.fieldOf(TAG_BUILDING_ID).forGetter(BuildingPos::getBuildingId)).apply((Applicative)builder, BuildingPos::new));
    @NotNull
    private final ResourceKey<Level> dimensionId;
    private final int colonyId;
    @NotNull
    private final BlockPos buildingId;

    public BuildingPos(@NotNull CompoundTag tag) {
        this.dimensionId = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TAG_DIMENSION_ID)));
        this.colonyId = tag.m_128451_(TAG_COLONY_ID);
        this.buildingId = BlockPosUtil.read((CompoundTag)tag, (String)TAG_BUILDING_ID);
    }

    public BuildingPos(@NotNull FriendlyByteBuf buffer) {
        this.dimensionId = buffer.m_236801_(Registries.f_256858_);
        this.colonyId = buffer.readInt();
        this.buildingId = buffer.m_130135_();
    }

    public BuildingPos(@NotNull ResourceKey<Level> dimensionId, int colonyId, @NotNull BlockPos buildingId) {
        this.dimensionId = dimensionId;
        this.colonyId = colonyId;
        this.buildingId = buildingId;
    }

    public BuildingPos(@NotNull IColony colony, @NotNull BlockPos buildingId) {
        this((ResourceKey<Level>)colony.getDimension(), colony.getID(), buildingId);
    }

    public BuildingPos(@NotNull IBuilding building) {
        this(building.getColony(), building.getID());
    }

    public BuildingPos(@NotNull IBuildingView buildingView) {
        this((IColony)buildingView.getColony(), buildingView.getID());
    }

    public int hashCode() {
        return Objects.hash(this.dimensionId, this.colonyId, this.buildingId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BuildingPos) {
            BuildingPos other = (BuildingPos)obj;
            return this.dimensionId == other.dimensionId && this.colonyId == other.colonyId && this.buildingId.equals((Object)other.buildingId);
        }
        return false;
    }

    @Nullable
    public IBuilding getBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, this.dimensionId);
        if (colony == null) {
            return null;
        }
        return colony.getBuildingManager().getBuilding(this.buildingId);
    }

    @Nullable
    public IBuildingView getBuildingView() {
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimensionId);
        if (colony == null) {
            return null;
        }
        return colony.getBuilding(this.buildingId);
    }

    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(TAG_DIMENSION_ID, this.dimensionId.m_135782_().toString());
        tag.m_128405_(TAG_COLONY_ID, this.colonyId);
        BlockPosUtil.write((CompoundTag)tag, (String)TAG_BUILDING_ID, (BlockPos)this.buildingId);
        return tag;
    }

    public void serializeBuffer(@NotNull FriendlyByteBuf buffer) {
        buffer.m_236858_(this.dimensionId);
        buffer.writeInt(this.colonyId);
        buffer.m_130064_(this.buildingId);
    }

    @NotNull
    public ResourceKey<Level> getDimensionId() {
        return this.dimensionId;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    @NotNull
    public BlockPos getBuildingId() {
        return this.buildingId;
    }

    public int getX() {
        return this.getBuildingId().m_123341_();
    }

    public int getY() {
        return this.getBuildingId().m_123342_();
    }

    public int getZ() {
        return this.getBuildingId().m_123343_();
    }
}

