/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public abstract class CustomizableObjectRegistry<OBJECT, ENTRY extends Entry> {
    public static final String TAG_ID = "ID";
    public static final String TAG_OBJECT = "Object";
    public static final ResourceLocation EMPTY_ID = MineColoniesTweaks.rl("empty");
    public static final String EMPTY_ID_STRING = EMPTY_ID.toString();
    private final Map<ResourceLocation, ENTRY> map = new HashMap<ResourceLocation, ENTRY>();

    protected void register(@NotNull ENTRY entry) {
        ResourceLocation id = ((Entry)entry).getId();
        if (this.map.containsKey(id)) {
            throw new IllegalArgumentException("ID " + id + " is already registered");
        }
        this.map.put(id, entry);
    }

    protected abstract ResourceLocation getId(OBJECT var1);

    protected abstract void serializeObject(@NotNull IFactoryController var1, @NotNull CompoundTag var2, @NotNull ENTRY var3, @Nullable OBJECT var4);

    protected abstract OBJECT deserializeObject(@NotNull IFactoryController var1, @NotNull CompoundTag var2, @NotNull ENTRY var3);

    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @Nullable OBJECT object) {
        CompoundTag tag = new CompoundTag();
        this.serialize(controller, tag, object);
        return tag;
    }

    public void serialize(@NotNull IFactoryController controller, @NotNull CompoundTag tag, @Nullable OBJECT object) {
        if (object == null) {
            return;
        }
        ResourceLocation id = this.getId(object);
        Entry entry = (Entry)this.map.get(id);
        if (entry == null) {
            throw new IllegalArgumentException("ID " + id + " is not registered");
        }
        tag.m_128359_(TAG_ID, id.toString());
        tag.m_128365_(TAG_OBJECT, (Tag)this.serializeWithoutId(controller, object));
    }

    public CompoundTag serializeWithoutId(@NotNull IFactoryController controller, @Nullable OBJECT object) {
        CompoundTag tag = new CompoundTag();
        this.serializeWithoutId(controller, tag, object);
        return tag;
    }

    public void serializeWithoutId(@NotNull IFactoryController controller, @NotNull CompoundTag tag, @Nullable OBJECT object) {
        if (object == null) {
            return;
        }
        ResourceLocation id = this.getId(object);
        Entry entry = (Entry)this.map.get(id);
        if (entry == null) {
            throw new IllegalArgumentException("ID " + id + " is not registered");
        }
        this.serializeObject(controller, tag, entry, object);
    }

    @Nullable
    public OBJECT deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag tag) {
        ResourceLocation id = new ResourceLocation(tag.m_128461_(TAG_ID));
        return this.deserializeWithoutId(controller, tag.m_128469_(TAG_OBJECT), id);
    }

    public OBJECT deserializeWithoutId(@NotNull IFactoryController controller, @NotNull CompoundTag tag, ResourceLocation id) {
        Entry entry = (Entry)this.map.get(id);
        if (entry == null) {
            return null;
        }
        return this.deserializeObject(controller, tag, entry);
    }

    public static abstract class Entry {
        @NotNull
        private ResourceLocation id;

        public Entry(@NotNull ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

