/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.libmc.Auxiliaries;

@OnlyIn(value=Dist.CLIENT)
public class TooltipDisplay {
    private static long default_delay = 450L;
    private static int default_max_deviation = 1;
    private List<TipRange> ranges = new ArrayList<TipRange>();
    private long delay = default_delay;
    private int max_deviation = default_max_deviation;
    private int x_last;
    private int y_last;
    private long t = System.currentTimeMillis();
    private final Font font;
    private static boolean had_render_exception = false;

    public static void config(int delay, int max_deviation) {
        default_delay = Mth.m_14045_((int)delay, (int)500, (int)5000);
        default_max_deviation = Mth.m_14045_((int)max_deviation, (int)1, (int)5);
    }

    public TooltipDisplay() {
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public TooltipDisplay init(List<TipRange> ranges, long delay_ms, int max_deviation_xy) {
        this.ranges = ranges;
        this.delay = delay_ms;
        this.max_deviation = max_deviation_xy;
        this.t = System.currentTimeMillis();
        this.y_last = 0;
        this.x_last = 0;
        return this;
    }

    public TooltipDisplay init(List<TipRange> ranges) {
        return this.init(ranges, default_delay, default_max_deviation);
    }

    public TooltipDisplay init(TipRange ... ranges) {
        return this.init(Arrays.asList(ranges), default_delay, default_max_deviation);
    }

    public TooltipDisplay delay(int ms) {
        this.delay = ms <= 0 ? default_delay : (long)ms;
        return this;
    }

    public void resetTimer() {
        this.t = System.currentTimeMillis();
    }

    public <T extends AbstractContainerMenu> boolean render(GuiGraphics gg, AbstractContainerScreen<T> gui, int x, int y) {
        if (had_render_exception) {
            return false;
        }
        if (Math.abs(x - this.x_last) > this.max_deviation || Math.abs(y - this.y_last) > this.max_deviation) {
            this.x_last = x;
            this.y_last = y;
            this.resetTimer();
            return false;
        }
        if (Math.abs(System.currentTimeMillis() - this.t) < this.delay) {
            return false;
        }
        if (this.ranges.stream().noneMatch(tip -> {
            if (x < tip.x0 || x > tip.x1 || y < tip.y0 || y > tip.y1) {
                return false;
            }
            Component tip_component = tip.text.get();
            if (tip_component.getString().isEmpty()) {
                return false;
            }
            try {
                List<Component> lines = Auxiliaries.wrapText(tip_component, 80);
                gg.m_280677_(this.font, lines, Optional.empty(), x, y);
            }
            catch (Exception ex) {
                had_render_exception = true;
                Auxiliaries.logError("Tooltip rendering disabled due to exception: '" + ex.getMessage() + "'");
                return false;
            }
            return true;
        })) {
            this.resetTimer();
            return false;
        }
        return true;
    }

    public static class TipRange {
        public final int x0;
        public final int y0;
        public final int x1;
        public final int y1;
        public final Supplier<Component> text;

        public TipRange(int x, int y, int w, int h, Component text) {
            this(x, y, w, h, () -> text);
        }

        public TipRange(int x, int y, int w, int h, Supplier<Component> text) {
            this.text = text;
            this.x0 = x;
            this.y0 = y;
            this.x1 = this.x0 + w - 1;
            this.y1 = this.y0 + h - 1;
        }
    }
}

