/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import net.minecraft.nbt.CompoundTag;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.player.config.IPlayerConfigClientStorage;
import xaero.pac.client.player.config.IPlayerConfigClientStorageManager;
import xaero.pac.client.player.config.IPlayerConfigStringableOptionClientStorage;
import xaero.pac.common.packet.config.ClientboundPlayerConfigAbstractStatePacket;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public class ClientboundPlayerConfigGeneralStatePacket
extends ClientboundPlayerConfigAbstractStatePacket {
    private final boolean beingDeleted;
    private final int subConfigLimit;

    public ClientboundPlayerConfigGeneralStatePacket(PlayerConfigType type, boolean otherPlayer, String subId, boolean beingDeleted, int subConfigLimit) {
        super(type, otherPlayer, subId);
        this.beingDeleted = beingDeleted;
        this.subConfigLimit = subConfigLimit;
    }

    public static class ClientHandler
    extends ClientboundPlayerConfigAbstractStatePacket.ClientHandler<ClientboundPlayerConfigGeneralStatePacket> {
        @Override
        protected void accept(ClientboundPlayerConfigGeneralStatePacket t, IPlayerConfigClientStorageManager<IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>>> playerConfigStorageManager, IPlayerConfigClientStorage<IPlayerConfigStringableOptionClientStorage<?>> storage) {
            storage.setGeneralState(t.beingDeleted, t.subConfigLimit);
        }
    }

    public static class Codec
    extends ClientboundPlayerConfigAbstractStatePacket.Codec<ClientboundPlayerConfigGeneralStatePacket> {
        @Override
        protected ClientboundPlayerConfigGeneralStatePacket decode(CompoundTag nbt, PlayerConfigType type, boolean otherPlayer, String subId) {
            if (!nbt.m_128425_("d", 1)) {
                OpenPartiesAndClaims.LOGGER.info("Unknown player config being deleted state!");
                return null;
            }
            boolean beingDeleted = nbt.m_128471_("d");
            int subConfigLimit = nbt.m_128451_("sl");
            return new ClientboundPlayerConfigGeneralStatePacket(type, otherPlayer, subId, beingDeleted, subConfigLimit);
        }

        @Override
        protected void encode(ClientboundPlayerConfigGeneralStatePacket packet, CompoundTag nbt) {
            nbt.m_128379_("d", packet.beingDeleted);
            nbt.m_128405_("sl", packet.subConfigLimit);
        }

        @Override
        protected int getExtraSizeLimit() {
            return 0;
        }
    }
}

