/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.rei;

import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.StoredItemStack;
import java.util.ArrayList;
import java.util.HashSet;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class ReiTransferHandler
implements TransferHandler {
    private CategoryIdentifier<?> CRAFTING = CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting");

    public TransferHandler.Result handle(TransferHandler.Context context) {
        if (context.getMenu() instanceof IAutoFillTerminal) {
            ResourceLocation recipeId;
            Recipe<?> rec;
            if (!context.getDisplay().getCategoryIdentifier().equals(this.CRAFTING) || context.getMinecraft().f_91080_ == context.getContainerScreen()) {
                return TransferHandler.Result.createNotApplicable();
            }
            Display recipe = context.getDisplay();
            ItemStack[][] stacks = (ItemStack[][])recipe.getInputEntries().stream().map(l -> (ItemStack[])l.stream().filter(es -> es.getDefinition().getValueType() == ItemStack.class).map(es -> es.getValue()).filter(e -> e != null).toArray(ItemStack[]::new)).toArray(x$0 -> new ItemStack[x$0][]);
            IAutoFillTerminal term = (IAutoFillTerminal)context.getMenu();
            ArrayList<Integer> missing = new ArrayList<Integer>();
            int width = recipe instanceof SimpleGridMenuDisplay ? ((SimpleGridMenuDisplay)recipe).getWidth() : Integer.MAX_VALUE;
            HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
            int i = 0;
            for (ItemStack[] list : stacks) {
                if (list.length > 0) {
                    boolean found = false;
                    for (ItemStack stack : list) {
                        if (stack == null || context.getMinecraft().f_91074_.m_150109_().m_36030_(stack) == -1) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        for (ItemStack stack : list) {
                            StoredItemStack s = new StoredItemStack(stack);
                            if (!stored.contains(s)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        missing.add(width == 1 ? i * 3 : (width == 2 ? i % 2 + i / 2 * 3 : i));
                    }
                }
                ++i;
            }
            if (context.isActuallyCrafting() && (rec = this.getRecipe(recipe)) != null && (recipeId = rec.m_6423_()) != null && !Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(recipeId).isEmpty()) {
                CompoundTag compound = new CompoundTag();
                compound.m_128359_("fill", recipeId.toString());
                term.sendMessage(compound);
                return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
            }
            if (!missing.isEmpty()) {
                return TransferHandler.Result.createSuccessful().color(1739237888).blocksFurtherHandling(false).renderer((gr, mouseX, mouseY, delta, widgets, bounds, d) -> {
                    int i = 0;
                    for (Widget widget : widgets) {
                        if (!(widget instanceof Slot) || ((Slot)widget).getNoticeMark() != 1 || !missing.contains(i++)) continue;
                        gr.m_280168_().m_85836_();
                        gr.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
                        Rectangle innerBounds = ((Slot)widget).getInnerBounds();
                        gr.m_280509_(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x40FF0000);
                        gr.m_280168_().m_85849_();
                    }
                });
            }
            return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
        }
        return TransferHandler.Result.createNotApplicable();
    }

    private Recipe<?> getRecipe(Display display) {
        Recipe holder;
        Object origin = DisplayRegistry.getInstance().getDisplayOrigin(display);
        return origin instanceof Recipe ? (holder = (Recipe)origin) : null;
    }
}

