/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkManager;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.NetworkType;
import com.refinedmods.refinedstorage.api.network.node.INetworkNodeProxy;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.Network;
import com.refinedmods.refinedstorage.apiimpl.network.node.RootNetworkNode;
import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.blockentity.ClientNode;
import com.refinedmods.refinedstorage.blockentity.config.IRedstoneConfigurable;
import com.refinedmods.refinedstorage.blockentity.config.RedstoneMode;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import com.refinedmods.refinedstorage.capability.NetworkNodeProxyCapability;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerBlockEntity
extends BaseBlockEntity
implements INetworkNodeProxy<RootNetworkNode>,
IRedstoneConfigurable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BlockEntitySynchronizationParameter<Integer, ControllerBlockEntity> REDSTONE_MODE = RedstoneMode.createParameter(new ResourceLocation("refinedstorage", "controller_redstone_mode"));
    public static final BlockEntitySynchronizationParameter<Integer, ControllerBlockEntity> ENERGY_USAGE = new BlockEntitySynchronizationParameter<Integer, ControllerBlockEntity>(new ResourceLocation("refinedstorage", "controller_energy_usage"), EntityDataSerializers.f_135028_, 0, t -> t.getNetwork().getEnergyUsage());
    public static final BlockEntitySynchronizationParameter<Integer, ControllerBlockEntity> ENERGY_STORED = new BlockEntitySynchronizationParameter<Integer, ControllerBlockEntity>(new ResourceLocation("refinedstorage", "controller_energy_stored"), EntityDataSerializers.f_135028_, 0, t -> t.getNetwork().getEnergyStorage().getEnergyStored());
    public static final BlockEntitySynchronizationParameter<Integer, ControllerBlockEntity> ENERGY_CAPACITY = new BlockEntitySynchronizationParameter<Integer, ControllerBlockEntity>(new ResourceLocation("refinedstorage", "controller_energy_capacity"), EntityDataSerializers.f_135028_, 0, t -> t.getNetwork().getEnergyStorage().getMaxEnergyStored());
    public static final BlockEntitySynchronizationParameter<List<ClientNode>, ControllerBlockEntity> NODES = new BlockEntitySynchronizationParameter<List, ControllerBlockEntity>(new ResourceLocation("refinedstorage", "controller_nodes"), RSSerializers.CLIENT_NODE_SERIALIZER, new ArrayList(), ControllerBlockEntity::collectClientNodes);
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addWatchedParameter(ENERGY_USAGE).addWatchedParameter(ENERGY_STORED).addParameter(ENERGY_CAPACITY).addParameter(NODES).build();
    private final LazyOptional<INetworkNodeProxy<RootNetworkNode>> networkNodeProxyCap = LazyOptional.of(() -> this);
    private final NetworkType type;
    private INetwork removedNetwork;
    private Network dummyNetwork;
    private final LazyOptional<IEnergyStorage> energyProxyCap = LazyOptional.of(() -> this.getNetwork().getEnergyStorage());

    public ControllerBlockEntity(NetworkType type, BlockPos pos, BlockState state) {
        super(type == NetworkType.CREATIVE ? (BlockEntityType)RSBlockEntities.CREATIVE_CONTROLLER.get() : (BlockEntityType)RSBlockEntities.CONTROLLER.get(), pos, state, SPEC);
        this.type = type;
    }

    private static List<ClientNode> collectClientNodes(ControllerBlockEntity blockEntity) {
        ArrayList<ClientNode> nodes = new ArrayList<ClientNode>();
        for (INetworkNodeGraphEntry entry : blockEntity.getNetwork().getNodeGraph().all()) {
            ItemStack stack;
            if (!entry.getNode().isActive() || (stack = entry.getNode().getItemStack()).m_41619_()) continue;
            ClientNode clientNode = new ClientNode(stack, 1, entry.getNode().getEnergyUsage());
            if (nodes.contains(clientNode)) {
                ClientNode other = (ClientNode)nodes.get(nodes.indexOf(clientNode));
                other.setAmount(other.getAmount() + 1);
                continue;
            }
            nodes.add(clientNode);
        }
        nodes.sort((a, b) -> Integer.compare(b.getEnergyUsage(), a.getEnergyUsage()));
        return nodes;
    }

    public INetwork getNetwork() {
        if (this.f_58857_.f_46443_) {
            if (this.dummyNetwork == null) {
                this.dummyNetwork = new Network(this.f_58857_, this.f_58858_, this.type);
            }
            return this.dummyNetwork;
        }
        INetworkManager manager = API.instance().getNetworkManager((ServerLevel)this.f_58857_);
        INetwork network = manager.getNetwork(this.f_58858_);
        if (network == null) {
            LOGGER.warn("Expected a network @ {} but couldn't find it, creating a new one...", (Object)this.f_58858_);
            network = new Network(this.f_58857_, this.f_58858_, this.type);
            manager.setNetwork(this.f_58858_, network);
            manager.markForSaving();
        }
        return network;
    }

    public void m_6339_() {
        INetworkManager manager;
        super.m_6339_();
        if (!this.f_58857_.f_46443_ && (manager = API.instance().getNetworkManager((ServerLevel)this.f_58857_)).getNetwork(this.f_58858_) == null) {
            manager.setNetwork(this.f_58858_, new Network(this.f_58857_, this.f_58858_, this.type));
            manager.markForSaving();
        }
    }

    @Override
    public void onRemovedNotDueToChunkUnload() {
        super.onRemovedNotDueToChunkUnload();
        if (!this.f_58857_.f_46443_) {
            INetwork network;
            INetworkManager manager = API.instance().getNetworkManager((ServerLevel)this.f_58857_);
            this.removedNetwork = network = manager.getNetwork(this.f_58858_);
            manager.removeNetwork(this.f_58858_);
            manager.markForSaving();
            network.onRemoved();
        }
    }

    public INetwork getRemovedNetwork() {
        return this.removedNetwork;
    }

    @Override
    @Nonnull
    public RootNetworkNode getNode() {
        return ((Network)this.getNetwork()).getRoot();
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return ((Network)this.getNetwork()).getRedstoneMode();
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        ((Network)this.getNetwork()).setRedstoneMode(mode);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyProxyCap.cast();
        }
        if (cap == NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY) {
            return this.networkNodeProxyCap.cast();
        }
        return super.getCapability(cap, direction);
    }
}

