/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Comparator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.ItemEffectHandler;
import se.mickelus.tetra.effect.JankEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.util.ToolActionHelper;

@ParametersAreNonnullByDefault
public class ThrownModularItemEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    public static final String unlocalizedName = "thrown_modular_item";
    public static final String stackKey = "stack";
    public static final String dealtDamageKey = "dealtDamage";
    public static final String preferredSlotKey = "preferredSlot";
    private static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.m_135353_(ThrownModularItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @ObjectHolder(registryName="entity_type", value="tetra:thrown_modular_item")
    public static EntityType<ThrownModularItemEntity> type;
    public static int preferUnavailable;
    public static int preferOffhand;
    public static int preferToolbelt;
    public int returningTicks;
    private ItemStack thrownStack = new ItemStack((ItemLike)Items.f_42713_);
    private boolean dealtDamage;
    private int preferredSlot = -1;
    private IntOpenHashSet hitEntities = new IntOpenHashSet(5);
    private int hitBlocks;
    private int despawnTimer = 0;

    public ThrownModularItemEntity(EntityType<? extends ThrownModularItemEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrownModularItemEntity(Level worldIn, Player thrower, ItemStack thrownStackIn) {
        super(type, (LivingEntity)thrower, worldIn);
        this.thrownStack = thrownStackIn.m_41777_();
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)thrownStackIn)));
        this.preferredSlot = thrower.m_7655_() == InteractionHand.MAIN_HAND ? thrower.m_150109_().f_35977_ : preferOffhand;
        CastOptional.cast((Object)this.thrownStack.m_41720_(), ItemModularHandheld.class).ifPresent(item -> {
            Level patt4451$temp;
            double critModifier = CritEffect.rollMultiplier(thrower.m_217043_(), item, this.thrownStack);
            this.m_36767_((byte)Math.round((double)this.getEffectLevel(ItemEffect.piercing) * critModifier));
            if (critModifier != 1.0 && (patt4451$temp = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt4451$temp;
                Vec3 pos = thrower.m_20299_(0.0f).m_82549_(thrower.m_20154_());
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 15, 0.2, 0.2, 0.2, 0.0);
            }
        });
        if (this.thrownStack.m_41720_() instanceof ModularSingleHeadedItem) {
            this.m_36740_(SoundEvents.f_12515_);
        } else if (this.thrownStack.m_41720_() instanceof ModularShieldItem) {
            this.m_36740_(SoundEvents.f_12314_);
        } else {
            this.m_36740_(SoundEvents.f_12318_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ThrownModularItemEntity(Level worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public ThrownModularItemEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity shooter = this.m_19749_();
        if ((this.dealtDamage || this.m_36797_()) && shooter != null) {
            byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
            if (loyaltyLevel > 0 && !this.shouldReturnToThrower()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else if (loyaltyLevel > 0) {
                this.m_36790_(true);
                Vec3 Vector3d = new Vec3(shooter.m_20185_() - this.m_20185_(), shooter.m_20188_() - this.m_20186_(), shooter.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + Vector3d.f_82480_ * 0.015 * (double)loyaltyLevel, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double speed = 0.05 * (double)loyaltyLevel;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(Vector3d.m_82541_().m_82490_(speed)));
                if (this.returningTicks == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                    this.m_20256_(Vector3d.m_82490_(0.01));
                }
                ++this.returningTicks;
            }
        }
        super.m_8119_();
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    public boolean hasDealtDamage() {
        return this.dealtDamage;
    }

    public boolean m_20096_() {
        return this.f_36704_ > 0;
    }

    private int getEffectLevel(ItemEffect effect) {
        return CastOptional.cast((Object)this.thrownStack.m_41720_(), IModularItem.class).map(item -> item.getEffectLevel(this.thrownStack, effect)).orElse(-1);
    }

    private float getEffectEfficiency(ItemEffect effect) {
        return CastOptional.cast((Object)this.thrownStack.m_41720_(), IModularItem.class).map(item -> Float.valueOf(item.getEffectEfficiency(this.thrownStack, effect))).orElse(Float.valueOf(-1.0f)).floatValue();
    }

    protected ItemStack m_7941_() {
        return this.thrownStack.m_41777_();
    }

    public ItemStack getThrownStack() {
        return this.thrownStack.m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.m_6351_(startVec, endVec);
    }

    protected void m_6532_(HitResult rayTraceResult) {
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK && !this.dealtDamage) {
            int jankLevel;
            BlockPos pos = ((BlockHitResult)rayTraceResult).m_82425_();
            Entity shooter = this.m_19749_();
            BlockState blockState = this.m_9236_().m_8055_(pos);
            ItemModularHandheld item = CastOptional.cast((Object)this.thrownStack.m_41720_(), ItemModularHandheld.class).orElse(null);
            if (ToolActionHelper.isEffectiveOn(this.thrownStack, blockState) && shooter instanceof Player) {
                Player player = (Player)shooter;
                if (item != null) {
                    double destroySpeed = item.m_8102_(this.thrownStack, blockState);
                    if (destroySpeed > 1.0 && destroySpeed * (double)item.getEffectEfficiency(this.thrownStack, ItemEffect.throwable) > (double)blockState.m_60800_((BlockGetter)this.m_9236_(), pos)) {
                        boolean canPierce;
                        if (shooter instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)shooter;
                            EffectHelper.sendEventToPlayer(serverPlayer, 2001, pos, Block.m_49956_((BlockState)blockState));
                        }
                        item.applyBlockBreakEffects(this.thrownStack, this.m_9236_(), blockState, pos, (LivingEntity)player);
                        ++this.hitBlocks;
                        boolean bl = canPierce = this.getEffectLevel(ItemEffect.piercingHarvest) > 0 && this.hitBlocks < this.m_36796_();
                        if (canPierce) {
                            this.m_20256_(this.m_20184_().m_82541_().m_82490_((double)0.8f));
                        } else {
                            this.dealtDamage = true;
                            super.m_6532_(rayTraceResult);
                        }
                        this.breakBlock(player, pos, blockState);
                        if (canPierce) {
                            this.hitAdditional();
                        }
                        return;
                    }
                    if (shooter instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)shooter;
                        serverPlayer.m_6330_(SoundEvents.f_12018_, SoundSource.BLOCKS, 0.5f, 0.5f);
                    }
                }
            }
            if (!this.m_9236_().f_46443_ && shooter != null && (jankLevel = this.getEffectLevel(ItemEffect.janking)) > 0) {
                JankEffect.jankItemsDelayed((ServerLevel)this.m_9236_(), pos, jankLevel, this.getEffectEfficiency(ItemEffect.janking), shooter);
            }
        }
        super.m_6532_(rayTraceResult);
    }

    private void hitAdditional() {
        Vec3 position = this.m_20182_();
        Vec3 target = position.m_82549_(this.m_20184_());
        BlockHitResult rayTraceResult = this.m_9236_().m_45547_(new ClipContext(position, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)rayTraceResult)) {
            this.m_6532_((HitResult)rayTraceResult);
        }
    }

    private void breakBlock(Player shooter, BlockPos pos, BlockState blockState) {
        ItemStack currentItem = shooter.m_21205_();
        shooter.m_21008_(InteractionHand.MAIN_HAND, this.thrownStack);
        EffectHelper.breakBlock(this.m_9236_(), shooter, this.thrownStack, pos, blockState, true, false);
        shooter.m_21008_(InteractionHand.MAIN_HAND, currentItem);
    }

    protected void m_5790_(EntityHitResult raytrace) {
        Entity target = raytrace.m_82443_();
        Entity shooter = this.m_19749_();
        Player playerShooter = CastOptional.cast((Object)shooter, Player.class).orElse(null);
        DamageSource damagesource = this.m_9236_().m_269111_().m_269525_((Entity)this, (Entity)(shooter == null ? this : shooter));
        SoundEvent soundevent = SoundEvents.f_12514_;
        int pierceLevel = this.getEffectLevel(ItemEffect.piercing);
        int ricochetLevel = this.getEffectLevel(ItemEffect.ricochet);
        if (pierceLevel > 0 || ricochetLevel > 0) {
            if (this.hitEntities == null) {
                this.hitEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities.contains(target.m_19879_())) {
                return;
            }
            if (this.hitEntities.size() < pierceLevel || this.hitEntities.size() < ricochetLevel) {
                this.hitEntities.add(target.m_19879_());
            } else {
                this.dealtDamage = true;
            }
        } else {
            this.dealtDamage = true;
        }
        ItemStack heldTemp = null;
        if (playerShooter != null) {
            heldTemp = playerShooter.m_21205_();
            playerShooter.m_21008_(InteractionHand.MAIN_HAND, this.thrownStack);
        }
        if (target instanceof LivingEntity && this.thrownStack.m_41720_() instanceof ItemModularHandheld) {
            LivingEntity targetLivingEntity = (LivingEntity)target;
            ItemModularHandheld item = (ItemModularHandheld)this.thrownStack.m_41720_();
            double critModifier = CritEffect.rollMultiplier(targetLivingEntity.m_217043_(), item, this.thrownStack);
            double damage = item.getAbilityBaseDamage(this.thrownStack) * (double)item.getEffectEfficiency(this.thrownStack, ItemEffect.throwable);
            damage += (double)EnchantmentHelper.m_44833_((ItemStack)this.thrownStack, (MobType)targetLivingEntity.m_6336_());
            if (target.m_6469_(damagesource, (float)(damage *= critModifier))) {
                if (shooter instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)targetLivingEntity, (Entity)shooter);
                    EffectHelper.applyEnchantmentHitEffects(this.m_7941_(), targetLivingEntity, (LivingEntity)shooter);
                    ItemEffectHandler.applyHitEffects(this.thrownStack, targetLivingEntity, (LivingEntity)shooter);
                    item.tickProgression((LivingEntity)shooter, this.thrownStack, 1);
                }
                this.m_7761_(targetLivingEntity);
                if (critModifier != 1.0 && !this.m_9236_().f_46443_) {
                    Vec3 hitVec = raytrace.m_82450_();
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123808_, hitVec.m_7096_(), hitVec.m_7098_(), hitVec.m_7094_(), 15, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        float f1 = 1.0f;
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46470_() && EnchantmentHelper.m_44936_((ItemStack)this.thrownStack)) {
            BlockPos blockpos = target.m_20183_();
            if (this.m_9236_().m_45527_(blockpos)) {
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                lightning.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
                lightning.m_20879_(shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null);
                this.m_9236_().m_7967_((Entity)lightning);
                soundevent = SoundEvents.f_12521_;
                f1 = 5.0f;
            }
        }
        if (playerShooter != null) {
            playerShooter.m_21008_(InteractionHand.MAIN_HAND, heldTemp);
        }
        this.m_5496_(soundevent, f1, 1.0f);
        if (this.dealtDamage) {
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        } else if (ricochetLevel > 0 && !this.m_9236_().f_46443_) {
            Vec3 hitPos = raytrace.m_82450_();
            this.m_20343_(hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_());
            this.m_20256_(this.m_9236_().m_6249_(shooter, new AABB(target.m_20183_()).m_82400_(8.0), entity -> !this.hitEntities.contains(entity.m_19879_()) && entity instanceof LivingEntity && !entity.m_6673_(damagesource) && (shooter == null || !entity.m_7307_(shooter))).stream().map(entity -> entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() * 0.8, 0.0)).map(pos -> pos.m_82546_(this.m_20182_())).min(Comparator.comparing(Vec3::m_82556_)).map(Vec3::m_82541_).map(direction -> direction.m_82542_(1.0, 0.5, 1.0)).map(direction -> direction.m_82490_(Math.max(this.m_20184_().m_82553_() * 0.5, 0.3))).orElse(this.m_20184_().m_82542_(-0.01, -0.1, -0.01)));
        }
    }

    protected boolean m_5603_(Entity target) {
        return super.m_5603_(target) && (this.hitEntities == null || !this.hitEntities.contains(target.m_19879_()));
    }

    public void m_6123_(Player entityIn) {
        Entity entity = this.m_19749_();
        if (entity == null || entity.m_20148_() == entityIn.m_20148_()) {
            super.m_6123_(entityIn);
        }
    }

    protected boolean m_142470_(Player player) {
        if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED && this.preferredSlot != -1) {
            Inventory inventory = player.m_150109_();
            if (this.preferredSlot == preferOffhand) {
                ItemStack blockingStack = player.m_21206_();
                player.m_21008_(InteractionHand.OFF_HAND, this.m_7941_());
                if (!blockingStack.m_41619_()) {
                    player.m_150109_().m_150079_(blockingStack);
                }
                return true;
            }
            ItemStack blockingStack = inventory.m_8020_(this.preferredSlot);
            boolean success = inventory.m_36040_(this.preferredSlot, this.m_7941_());
            if (success) {
                if (!blockingStack.m_41619_()) {
                    player.m_150109_().m_150079_(blockingStack);
                }
                return true;
            }
        }
        return super.m_142470_(player);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_(stackKey, 10)) {
            this.thrownStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_(stackKey));
        }
        this.dealtDamage = compound.m_128471_(dealtDamageKey);
        this.preferredSlot = compound.m_128441_(preferredSlotKey) ? compound.m_128451_(preferredSlotKey) : -1;
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.thrownStack)));
        if (this.thrownStack.m_41720_() instanceof ModularSingleHeadedItem) {
            this.m_36740_(SoundEvents.f_12515_);
        } else if (this.thrownStack.m_41720_() instanceof ModularShieldItem) {
            this.m_36740_(SoundEvents.f_12314_);
        } else {
            this.m_36740_(SoundEvents.f_12318_);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_(stackKey, (Tag)this.thrownStack.m_41739_(new CompoundTag()));
        compound.m_128379_(dealtDamageKey, this.dealtDamage);
        compound.m_128405_(preferredSlotKey, this.preferredSlot);
    }

    public void m_6901_() {
        byte level = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || level <= 0) {
            ++this.despawnTimer;
            if (this.despawnTimer > 72000 && !this.m_146886_()) {
                this.m_146915_(true);
            }
            if (this.despawnTimer >= 500000) {
                this.m_146870_();
            }
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.thrownStack);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.thrownStack = buffer.m_130267_();
    }

    static {
        preferUnavailable = -3;
        preferOffhand = -2;
        preferToolbelt = -1;
    }
}

