/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.potion;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import se.mickelus.tetra.TetraDamageTypes;
import se.mickelus.tetra.client.particle.DripParticles;
import se.mickelus.tetra.effect.gui.EffectUnRenderer;

@ParametersAreNonnullByDefault
public class BleedingPotionEffect
extends MobEffect {
    public static final String identifier = "bleeding";
    public static BleedingPotionEffect instance;
    public static final TagKey<EntityType<?>> slimebloodTag;
    public static final TagKey<EntityType<?>> lavabloodTag;

    public BleedingPotionEffect() {
        super(MobEffectCategory.HARMFUL, 0x880000);
        instance = this;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        DamageSource source = entity.m_9236_().m_269111_().m_269079_(TetraDamageTypes.bleeding);
        entity.m_6469_(source, (float)amplifier);
        BleedingPotionEffect.spawnParticles(entity, 2);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 10 == 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(EffectUnRenderer.INSTANCE);
    }

    public static void spawnParticles(LivingEntity entity, int count) {
        if (!entity.m_9236_().f_46443_) {
            RandomSource random = entity.m_217043_();
            AABB boundingBox = entity.m_20191_().m_82377_(0.1, 0.1, 0.1);
            Vec3 target = BleedingPotionEffect.getRandomVec3InAABB(boundingBox, random);
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)BleedingPotionEffect.getBloodParticleType(entity), target.m_7096_(), target.m_7098_(), target.m_7094_(), count, 0.0, 0.0, 0.0, (double)0.05f);
        }
    }

    private static Vec3 getRandomVec3InAABB(AABB box, RandomSource random) {
        double x = box.f_82288_ + random.m_188500_() * (box.f_82291_ - box.f_82288_);
        double y = box.f_82289_ + random.m_188500_() * (box.f_82292_ - box.f_82289_);
        double z = box.f_82290_ + random.m_188500_() * (box.f_82293_ - box.f_82290_);
        return new Vec3(x, y, z);
    }

    private static SimpleParticleType getBloodParticleType(LivingEntity entity) {
        if (entity.m_6095_().m_204039_(slimebloodTag)) {
            return (SimpleParticleType)DripParticles.fallingSlime.get();
        }
        if (entity.m_6095_().m_204039_(lavabloodTag)) {
            return ParticleTypes.f_123801_;
        }
        return (SimpleParticleType)DripParticles.fallingBlood.get();
    }

    static {
        slimebloodTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("tetra", "slimeblood"));
        lavabloodTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("tetra", "lavablood"));
    }
}

