/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data.condition;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.ItemEffectData;
import se.mickelus.tetra.effect.data.condition.ItemEffectCondition;
import se.mickelus.tetra.effect.data.provider.number.ExpressionNumberProvider;
import se.mickelus.tetra.effect.data.provider.number.NumberProvider;

public class ExpressionItemEffectCondition
extends ItemEffectCondition {
    private static final Type dataType = new TypeToken<Map<String, NumberProvider>>(){}.getType();
    NumberProvider left;
    NumberProvider right;
    Operator operator;
    @Nullable
    Map<String, NumberProvider> numbers;

    public ExpressionItemEffectCondition(NumberProvider left, NumberProvider right, Operator operator, @Nullable Map<String, NumberProvider> numbers) {
        this.left = left;
        this.right = right;
        this.operator = operator;
        this.numbers = numbers;
    }

    @Override
    public boolean test(ItemEffectContext context) {
        if (this.numbers != null) {
            context = context.withMergedNumbers(ItemEffectData.calculateNumbers(this.numbers, context));
        }
        return this.operator.comparator.apply(Float.valueOf(this.left.getValue(context)), Float.valueOf(this.right.getValue(context)));
    }

    public static ItemEffectCondition deserialize(JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String fullExpression = jsonObject.get("expression").getAsString();
        for (Operator operator : Operator.values()) {
            String[] expressionParts;
            if (!fullExpression.contains(operator.key) || (expressionParts = fullExpression.split(operator.key)).length != 2) continue;
            NumberProvider left = ExpressionNumberProvider.parseExpression(expressionParts[0]);
            NumberProvider right = ExpressionNumberProvider.parseExpression(expressionParts[1]);
            Map data = (Map)DataManager.gson.fromJson(jsonObject.get("numbers"), dataType);
            return new ExpressionItemEffectCondition(left, right, operator, data);
        }
        throw new JsonParseException("Could not parse expression condition '" + fullExpression + "', missing operator");
    }

    public static enum Operator {
        notEquals("!=", (a, b) -> !a.equals(b)),
        equals("==", Float::equals),
        lessThanOrEquals("<=", (a, b) -> a.floatValue() <= b.floatValue()),
        greaterThanOrEquals(">=", (a, b) -> a.floatValue() >= b.floatValue()),
        lessThan("<", (a, b) -> a.floatValue() < b.floatValue()),
        greaterThan(">", (a, b) -> a.floatValue() > b.floatValue());

        final String key;
        final BiFunction<Float, Float, Boolean> comparator;

        private Operator(String key, BiFunction<Float, Float, Boolean> comparator) {
            this.key = key;
            this.comparator = comparator;
        }
    }
}

