/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;
import se.mickelus.tetra.client.particle.PlainParticleType;

@MethodsReturnNonnullByDefault
public record PlainParticleOption(Vector3f color, float gravity, float friction) implements ParticleOptions
{
    public static final Codec<PlainParticleOption> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.f_252432_.fieldOf("color").forGetter(option -> option.color), (App)Codec.FLOAT.fieldOf("gravity").forGetter(i -> Float.valueOf(i.gravity)), (App)Codec.FLOAT.fieldOf("friction").forGetter(i -> Float.valueOf(i.friction))).apply((Applicative)builder, PlainParticleOption::new));
    public static final ParticleOptions.Deserializer<PlainParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<PlainParticleOption>(){

        public PlainParticleOption fromCommand(ParticleType<PlainParticleOption> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float red = reader.readFloat();
            reader.expect(' ');
            float green = reader.readFloat();
            reader.expect(' ');
            float blue = reader.readFloat();
            reader.expect(' ');
            float gravity = reader.readFloat();
            reader.expect(' ');
            float friction = reader.readFloat();
            return new PlainParticleOption(new Vector3f(red, green, blue), gravity, friction);
        }

        public PlainParticleOption fromNetwork(ParticleType<PlainParticleOption> type, FriendlyByteBuf buffer) {
            return new PlainParticleOption(new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), buffer.readFloat(), buffer.readFloat());
        }
    };

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.color.x());
        buffer.writeFloat(this.color.y());
        buffer.writeFloat(this.color.z());
        buffer.writeFloat(this.gravity);
        buffer.writeFloat(this.friction);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()), Float.valueOf(this.gravity), Float.valueOf(this.friction));
    }

    public ParticleType<PlainParticleOption> m_6012_() {
        return PlainParticleType.instance;
    }
}

