/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits;

import com.eccarrascon.structurecredits.GetConfigDir;
import com.eccarrascon.structurecredits.StructureCredits;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigData {
    private static final File CONFIG_DATA_FILE = new File(GetConfigDir.getConfigDirectory().toFile(), "structurecredits-config.json");
    private boolean active = true;
    private boolean showOnlyOneTime = true;
    private boolean chatMessage = false;
    private boolean showCreator = true;
    private Map<String, String> customStructureName = new HashMap<String, String>(){
        {
            this.put("minecraft:swamp_hut", "a_cat:cat_hut");
        }
    };
    private List<String> dontShowAll = List.of("minecraft:", "dimdungeons:");
    private List<String> dontShow = List.of("minecraft:plains_village", "minecraft:desert_village");

    public static ConfigData init() {
        ConfigData configuration = new ConfigData();
        if (!CONFIG_DATA_FILE.exists()) {
            ConfigData.save(configuration);
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_DATA_FILE.toPath());){
            configuration = (ConfigData)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, ConfigData.class);
        }
        catch (IOException e) {
            StructureCredits.LOGGER.error("Failed to load the configuration file. Possible issues with the file format or content. Using default configuration. Details: {}", (Object)e.getMessage(), (Object)e);
        }
        return configuration;
    }

    public static void save(ConfigData config) {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_DATA_FILE.toPath(), new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            StructureCredits.LOGGER.error("Error while trying to save configuration file. Details: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public Map<String, String> getCustomStructureName() {
        return this.customStructureName;
    }

    public List<String> getDontShow() {
        return this.dontShow;
    }

    public List<String> getDontShowAll() {
        return this.dontShowAll;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isOnlyOneTime() {
        return this.showOnlyOneTime;
    }

    public boolean isChatMessage() {
        return this.chatMessage;
    }

    public boolean isShowCreator() {
        return this.showCreator;
    }
}

