/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common.items;

import com.oitsjustjose.natprog.NatProg;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class DynamicItemTier
implements Tier {
    private int uses = 0;
    private float speed = 0.0f;
    private float attackDamageBonus = 0.0f;
    private int harvestLvl = 0;
    private int enchantability = 0;
    private Ingredient repairIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42127_});

    public DynamicItemTier setMaxUses(int maxUses) {
        this.uses = maxUses;
        return this;
    }

    public DynamicItemTier setEfficiency(float eff) {
        this.speed = eff;
        return this;
    }

    public DynamicItemTier setAttackDamage(float dmg) {
        this.attackDamageBonus = dmg;
        return this;
    }

    public DynamicItemTier setHarvestLvl(int lvl) {
        this.harvestLvl = lvl;
        return this;
    }

    public DynamicItemTier setEnchantability(int ench) {
        this.enchantability = ench;
        return this;
    }

    public DynamicItemTier setRepairMat(@Nullable TagKey<Item> tag) {
        if (tag == null) {
            return this;
        }
        List tagItems = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(tag).stream().toList();
        if (tagItems.size() == 0) {
            this.repairIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42127_});
            NatProg.getInstance().LOGGER.warn("Dynamic saw repair material {} could not be found. Defaulting to Bedrock", (Object)tag.toString());
        } else {
            this.repairIngredient = Ingredient.m_204132_(tag);
        }
        return this;
    }

    public DynamicItemTier setRepairMats(Item ... items) {
        this.repairIngredient = Ingredient.m_43929_((ItemLike[])items);
        return this;
    }

    public int m_6609_() {
        return this.uses;
    }

    public float m_6624_() {
        return this.speed;
    }

    public float m_6631_() {
        return this.attackDamageBonus;
    }

    public int m_6604_() {
        return this.harvestLvl;
    }

    public int m_6601_() {
        return this.enchantability;
    }

    @Nonnull
    public Ingredient m_6282_() {
        return this.repairIngredient;
    }
}

