/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common.event.block;

import com.oitsjustjose.natprog.NatProg;
import com.oitsjustjose.natprog.common.config.CommonConfig;
import com.oitsjustjose.natprog.common.event.DamageTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WoodBreak {
    public static final TagKey<Item> CONSIDERED_AS_AXE = ItemTags.create((ResourceLocation)new ResourceLocation("natprog", "considered_as_axe"));
    public static final TagKey<Block> IGNORED_WOOD_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("natprog", "ignored_wood_blocks"));
    public static final TagKey<Block> WOOD_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("natprog", "woods_requiring_tool"));

    @SubscribeEvent
    public void registerEvent(PlayerEvent.BreakSpeed evt) {
        if (evt.getState() == null || evt.getEntity() == null || evt.getPosition().isEmpty()) {
            return;
        }
        if (evt.getState().m_204336_(IGNORED_WOOD_BLOCKS) || !evt.getState().m_204336_(WOOD_BLOCKS)) {
            return;
        }
        ItemStack heldItem = evt.getEntity().m_21205_();
        if (heldItem.m_204117_(CONSIDERED_AS_AXE)) {
            return;
        }
        if (heldItem.canPerformAction(ToolActions.AXE_DIG)) {
            return;
        }
        Level level = evt.getEntity().m_9236_();
        evt.setCanceled(true);
        if (evt.getEntity().m_21205_().m_41619_() && evt.getEntity().m_217043_().m_188503_(25) == 1 && ((Boolean)CommonConfig.INCORRECT_TOOL_DAMAGE.get()).booleanValue()) {
            if (evt.getEntity().m_217043_().m_188503_(10) == 1) {
                evt.getEntity().m_6469_(DamageTypes.getDamageSource(level, DamageTypes.SPLINTERING), 1.0f);
            } else {
                NatProg.proxy.doHurtAnimation(evt.getEntity());
            }
        }
        if (!((Boolean)CommonConfig.SHOW_BREAKING_HELP.get()).booleanValue()) {
            return;
        }
        evt.getEntity().m_5661_((Component)Component.m_237115_((String)"natprog.wood.warning"), true);
    }
}

