/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common.data.damageitem;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DamageItemRecipe
extends ShapelessRecipe {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public DamageItemRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack output, NonNullList<Ingredient> inputs) {
        super(id, group, category, output, inputs);
        this.inputs = inputs;
        this.output = output;
    }

    @Nonnull
    public ItemStack m_5874_(@NotNull CraftingContainer container, @NotNull RegistryAccess access) {
        return this.output.m_41777_();
    }

    public boolean m_5818_(CraftingContainer inv, @NotNull Level level) {
        StackedContents stackedcontents = new StackedContents();
        int i = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            stackedcontents.m_36468_(itemstack, 1);
        }
        return i == this.inputs.size() && stackedcontents.m_36475_((Recipe)this, null);
    }

    public ItemStack getResultItem() {
        return this.output.m_41777_();
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList ret = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < ret.size(); ++i) {
            boolean shouldAttemptDmg;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41720_().isDamageable(stack)) continue;
            ItemStack savedStack = stack.m_41777_();
            Random random = new Random();
            int unbreakingLvl = savedStack.getEnchantmentLevel(Enchantments.f_44986_);
            boolean bl = shouldAttemptDmg = unbreakingLvl <= 0 || 1 + random.nextInt(5) <= unbreakingLvl;
            if (savedStack.m_41773_() < savedStack.m_41776_()) {
                if (shouldAttemptDmg) {
                    savedStack.m_41721_(savedStack.m_41773_() + 1);
                }
                ret.set(i, (Object)savedStack);
                continue;
            }
            ret.set(i, (Object)ItemStack.f_41583_);
        }
        return ret;
    }
}

