/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;

public class EnumMapper<K extends Enum<K>, V extends Enum<V>> {
    private final V[] idToValues;
    private final K[] idToKeys;

    private EnumMapper(K[] idToKeys, V[] idToValues) {
        this.idToKeys = idToKeys;
        this.idToValues = idToValues;
    }

    public static <K extends Enum<K>, V extends Enum<V>> EnumMapper<K, V> create(K defaultKey, V defaultValue, Consumer<Builder<K, V>> consumer) {
        Builder<K, V> builder = new Builder<K, V>(defaultKey, defaultValue);
        consumer.accept(builder);
        return builder.build();
    }

    public K getKey(V obj) {
        return this.idToKeys[((Enum)obj).ordinal()];
    }

    public V getValue(K obj) {
        return this.idToValues[((Enum)obj).ordinal()];
    }

    public static class Builder<K extends Enum<K>, V extends Enum<V>> {
        private final HashMap<K, V> keyMap = new HashMap();
        private final HashMap<V, K> valueMap = new HashMap();
        private final K[] allKeys;
        private final V[] allValues;
        private final K defaultKey;
        private final V defaultValue;

        public Builder(K defaultKey, V defaultValue) {
            this.allKeys = (Enum[])((Enum)defaultKey).getDeclaringClass().getEnumConstants();
            this.allValues = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants();
            this.defaultKey = defaultKey;
            this.defaultValue = defaultValue;
        }

        public void add(K key, V value) {
            this.keyMap.put(key, value);
            this.valueMap.put(value, key);
        }

        private EnumMapper<K, V> build() {
            Enum[] idToValues = (Enum[])Arrays.copyOf(this.allValues, this.allKeys.length);
            for (K key : this.allKeys) {
                idToValues[((Enum)key).ordinal()] = (Enum)this.keyMap.getOrDefault(key, this.defaultValue);
            }
            Enum[] idToKeys = (Enum[])Arrays.copyOf(this.allKeys, this.allValues.length);
            for (V value : this.allValues) {
                idToKeys[((Enum)value).ordinal()] = (Enum)this.valueMap.getOrDefault(value, this.defaultKey);
            }
            return new EnumMapper(idToKeys, idToValues);
        }
    }
}

