/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.network;

import java.util.Optional;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.permission.BlockPermission;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.library.data.SkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryFile;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class UpdateLibraryFilePacket
extends CustomPacket {
    private final Mode mode;
    private final String source;
    private final String destination;

    public UpdateLibraryFilePacket(Mode mode, String source, String destination) {
        this.mode = mode;
        this.source = source;
        this.destination = destination;
    }

    public UpdateLibraryFilePacket(IFriendlyByteBuf buffer) {
        this.mode = buffer.readEnum(Mode.class);
        this.destination = (this.mode.flag & 1) != 0 ? this.decodePath(buffer) : "";
        this.source = (this.mode.flag & 2) != 0 ? this.decodePath(buffer) : this.destination;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum(this.mode);
        if ((this.mode.flag & 1) != 0) {
            buffer.writeUtf(this.destination);
        }
        if ((this.mode.flag & 2) != 0) {
            buffer.writeUtf(this.source);
        }
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        String playerName = player.m_6302_();
        if (!this.mode.permission.accept((Player)player)) {
            return;
        }
        SkinLibrary library = SkinLibraryManager.getServer().getLibrary();
        if (this.mode == Mode.RELOAD) {
            library.reload();
            return;
        }
        if (!this.isAuthorized((Player)player)) {
            ModLog.info("the {} operation rejected for '{}', dest: '{}'", new Object[]{this.mode, playerName, this.destination});
            return;
        }
        ModLog.info("the {} operation accepted for '{}', dest: '{}'", new Object[]{this.mode, playerName, this.destination});
        switch (this.mode.ordinal()) {
            case 1: {
                library.mkdir(this.destination);
                break;
            }
            case 2: {
                this.getFile(this.source).ifPresent(file -> library.rename((SkinLibraryFile)file, this.destination));
                break;
            }
            case 3: {
                this.getFile(this.source).ifPresent(library::delete);
            }
        }
    }

    private String decodePath(IFriendlyByteBuf buffer) {
        String path = FileUtils.normalize(buffer.readUtf(), true);
        if (path != null) {
            return path;
        }
        return "";
    }

    private Optional<SkinLibraryFile> getFile(String path) {
        return Optional.of(SkinLibraryManager.getServer().getLibrary().get(path));
    }

    private boolean isAuthorized(Player player) {
        if (this.destination.isEmpty()) {
            return false;
        }
        String key = "/private/" + player.m_20149_();
        if (this.destination.startsWith(key) && this.source.startsWith(key)) {
            return true;
        }
        return SkinLibraryManager.getServer().shouldMaintenanceFile(player);
    }

    public static enum Mode {
        RELOAD(0, ModPermissions.SKIN_LIBRARY_RELOAD),
        MKDIR(1, ModPermissions.SKIN_LIBRARY_MKDIR),
        RENAME(3, ModPermissions.SKIN_LIBRARY_RENAME),
        DELETE(1, ModPermissions.SKIN_LIBRARY_DELETE);

        final int flag;
        final BlockPermission permission;

        private Mode(int flag, BlockPermission permission) {
            this.flag = flag;
            this.permission = permission;
        }
    }
}

