/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.menu;

import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.library.blockentity.SkinLibraryBlockEntity;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class SkinLibraryMenu
extends AbstractBlockEntityMenu<SkinLibraryBlockEntity> {
    protected final Container inventory = ((SkinLibraryBlockEntity)this.blockEntity).getInventory();
    protected final Inventory playerInventory;
    public int inventoryWidth = 162;
    public int inventoryHeight = 76;
    private int libraryVersion = 0;

    public SkinLibraryMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos access) {
        super((MenuType)menuType, block, containerId, access);
        this.playerInventory = playerInventory;
        this.reload(0, 0, 240, 240);
    }

    public void reload(int x, int y, int width, int height) {
        int inventoryX = 6;
        int inventoryY = height - this.inventoryHeight - 4;
        this.f_38839_.clear();
        this.addPlayerSlots((Container)this.playerInventory, inventoryX, inventoryY);
        this.addInputSlot(this.inventory, 0, inventoryX, inventoryY - 27);
        this.addOutputSlot(this.inventory, 1, inventoryX + this.inventoryWidth - 22, inventoryY - 27);
    }

    public void m_38946_() {
        SkinLibraryManager.Server server;
        super.m_38946_();
        if (this.playerInventory.f_35978_ instanceof ServerPlayer && this.libraryVersion != (server = SkinLibraryManager.getServer()).getVersion()) {
            server.sendTo((ServerPlayer)this.playerInventory.f_35978_);
            this.libraryVersion = server.getVersion();
        }
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        return this.quickMoveStack(player, index, this.f_38839_.size() - 1);
    }

    protected void addInputSlot(Container inventory, int slot, int x, int y) {
        this.m_38897_(new Slot(inventory, slot, x, y){

            public boolean m_5857_(ItemStack itemStack) {
                return itemStack.m_150930_((Item)ModItems.SKIN_TEMPLATE.get()) || !SkinDescriptor.of(itemStack).isEmpty();
            }
        });
    }

    protected void addOutputSlot(Container inventory, int slot, int x, int y) {
        this.m_38897_(new Slot(inventory, slot, x, y){

            public boolean m_5857_(ItemStack itemStack) {
                return false;
            }
        });
    }

    public ItemStack getInputStack() {
        return this.inventory.m_8020_(0);
    }

    public ItemStack getOutputStack() {
        return this.inventory.m_8020_(1);
    }

    public Player getPlayer() {
        return this.playerInventory.f_35978_;
    }

    public boolean shouldSaveStack() {
        return this.getOutputStack().m_41619_();
    }

    public boolean shouldLoadStack() {
        return this.getOutputStack().m_41619_() && !this.getInputStack().m_41619_() && this.getInputStack().m_150930_((Item)ModItems.SKIN_TEMPLATE.get());
    }

    public void crafting(SkinDescriptor descriptor) {
        boolean consume = true;
        ItemStack itemStack = this.getInputStack();
        ItemStack newItemStack = itemStack.m_41777_();
        if (descriptor != null) {
            newItemStack = this.create(newItemStack, descriptor);
            consume = itemStack.m_150930_((Item)ModItems.SKIN_TEMPLATE.get());
        }
        this.inventory.m_6836_(1, newItemStack);
        if (consume) {
            itemStack.m_41774_(1);
        }
    }

    private ItemStack create(ItemStack targetStack, SkinDescriptor descriptor) {
        if (targetStack.m_41619_()) {
            return descriptor.asItemStack();
        }
        if (targetStack.m_150930_((Item)ModItems.SKIN_TEMPLATE.get())) {
            return descriptor.asItemStack();
        }
        if (descriptor.isEmpty()) {
            ComponentAPI.remove(targetStack, (IDataComponentType)ModDataComponents.SKIN.get());
        } else {
            ComponentAPI.set(targetStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor);
        }
        return targetStack;
    }
}

