/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.library.ISkinLibraryListener;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.DataEncryptMethod;
import moe.plushie.armourers_workshop.core.data.DataManager;
import moe.plushie.armourers_workshop.core.utils.OpenUUID;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.data.SkinLibrary;
import moe.plushie.armourers_workshop.library.data.SkinLibraryFile;
import moe.plushie.armourers_workshop.library.data.SkinLibrarySetting;
import moe.plushie.armourers_workshop.library.network.UpdateLibraryFilesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class SkinLibraryManager
implements ISkinLibraryListener {
    protected boolean isRunning = false;
    protected final ArrayList<ISkinLibraryListener> listeners = new ArrayList();

    public static Client getClient() {
        return Client.INSTANCE;
    }

    public static Server getServer() {
        return Server.INSTANCE;
    }

    public static void startClient() {
        SkinLibraryManager.getClient().start();
    }

    public static void startServer() {
        SkinLibraryManager.getServer().start();
    }

    public abstract void start();

    public abstract void stop();

    public void addListener(ISkinLibraryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ISkinLibraryListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean shouldDownloadFile(Player player) {
        return true;
    }

    public boolean shouldUploadFile(Player player) {
        return true;
    }

    public boolean shouldMaintenanceFile(Player player) {
        return true;
    }

    @Override
    public void libraryDidReload(ISkinLibrary library) {
        this.listeners.forEach(listener -> listener.libraryDidReload(library));
    }

    @Override
    public void libraryDidChanges(ISkinLibrary library, ISkinLibrary.Difference difference) {
        this.listeners.forEach(listener -> listener.libraryDidChanges(library, difference));
    }

    public static class Client
    extends SkinLibraryManager {
        private static final Client INSTANCE = new Client();
        private final SkinLibrary localSkinLibrary;
        private final SkinLibrary publicSkinLibrary;
        private final SkinLibrary privateSkinLibrary;
        private SkinLibrarySetting setting = SkinLibrarySetting.DEFAULT;

        public Client() {
            this.localSkinLibrary = new SkinLibrary(DataDomain.LOCAL, EnvironmentManager.getSkinLibraryDirectory());
            this.publicSkinLibrary = new SkinLibrary.Proxy(DataDomain.DEDICATED_SERVER);
            this.privateSkinLibrary = new SkinLibrary.Proxy(DataDomain.DEDICATED_SERVER);
            this.localSkinLibrary.addListener(this);
            this.publicSkinLibrary.addListener(this);
            this.privateSkinLibrary.addListener(this);
        }

        @Override
        public void start() {
            this.localSkinLibrary.markBaseDir();
            this.localSkinLibrary.reload();
            this.isRunning = true;
        }

        @Override
        public void stop() {
            this.isRunning = false;
            this.publicSkinLibrary.reset();
            this.privateSkinLibrary.reset();
        }

        @Override
        public boolean shouldDownloadFile(Player player) {
            if (!DataManager.getInstance().isConnected()) {
                if (this.shouldMaintenanceFile(player)) {
                    return true;
                }
                return ModConfig.Common.allowDownloadingSkins && this.setting.allowsDownload();
            }
            return true;
        }

        @Override
        public boolean shouldUploadFile(Player player) {
            if (!DataManager.getInstance().isConnected()) {
                if (this.shouldMaintenanceFile(player)) {
                    return true;
                }
                return ModConfig.Common.allowUploadingSkins && this.setting.allowsUpload();
            }
            return true;
        }

        @Override
        public boolean shouldMaintenanceFile(Player player) {
            return ModConfig.Common.allowLibraryRemoteManage && this.setting.allowsMaintenance();
        }

        public SkinLibrary getLocalSkinLibrary() {
            return this.localSkinLibrary;
        }

        public SkinLibrary getPublicSkinLibrary() {
            return this.publicSkinLibrary;
        }

        public SkinLibrary getPrivateSkinLibrary() {
            return this.privateSkinLibrary;
        }

        public void setSetting(SkinLibrarySetting setting) {
            this.setting = setting;
        }

        public SkinLibrarySetting getSetting() {
            return this.setting;
        }
    }

    public static class Server
    extends SkinLibraryManager {
        private static final Server INSTANCE = new Server();
        private final SkinLibrary skinLibrary;
        private final ArrayList<SkinLibraryFile> publicFiles = new ArrayList();
        private final HashMap<String, ArrayList<SkinLibraryFile>> privateFiles = new HashMap();
        private final HashSet<String> syncedPlayers = new HashSet();
        private int version = 0;
        private String publicKey;
        private String privateKey;
        private boolean isReady = false;

        public Server() {
            this.skinLibrary = new SkinLibrary(DataDomain.DEDICATED_SERVER, EnvironmentManager.getSkinLibraryDirectory());
            this.skinLibrary.addListener(this);
        }

        @Override
        public void start() {
            this.skinLibrary.markBaseDir();
            this.skinLibrary.reload();
            this.isRunning = true;
        }

        @Override
        public void stop() {
            this.isRunning = false;
            this.skinLibrary.reset();
            this.publicFiles.clear();
            this.privateFiles.clear();
            this.syncedPlayers.clear();
            this.version = 0;
            this.publicKey = null;
            this.privateKey = null;
            this.isReady = false;
        }

        public void remove(Player player) {
            ModLog.debug("remove synced player {}", player.m_20149_());
            this.syncedPlayers.remove(player.m_20149_());
        }

        @Override
        public void libraryDidReload(ISkinLibrary library) {
            ArrayList<SkinLibraryFile> publicFiles = new ArrayList<SkinLibraryFile>();
            HashMap<String, ArrayList> privateFiles = new HashMap<String, ArrayList>();
            for (SkinLibraryFile file : this.skinLibrary.getFiles()) {
                String path = file.getPath();
                if (path.startsWith("/private")) {
                    int index = path.indexOf(47, "/private".length() + 1);
                    if (index < 0) continue;
                    String key = path.substring(0, index);
                    privateFiles.computeIfAbsent(key, k -> new ArrayList()).add(file);
                    continue;
                }
                publicFiles.add(file);
            }
            if (this.isReady && this.publicFiles.equals(publicFiles) && this.privateFiles.equals(privateFiles)) {
                return;
            }
            this.isReady = true;
            this.syncedPlayers.clear();
            this.publicFiles.clear();
            this.publicFiles.addAll(publicFiles);
            this.privateFiles.clear();
            this.privateFiles.putAll(privateFiles);
            ++this.version;
            super.libraryDidReload(library);
        }

        public void sendTo(ServerPlayer player) {
            if (!this.isReady) {
                return;
            }
            String uuid = player.m_20149_();
            if (this.syncedPlayers.contains(uuid)) {
                return;
            }
            this.syncedPlayers.add(uuid);
            String key = "/private/" + uuid;
            String name = player.m_6302_();
            SkinLibrarySetting setting = new SkinLibrarySetting((Player)player);
            ArrayList<SkinLibraryFile> privateFiles = this.privateFiles.getOrDefault(key, new ArrayList());
            UpdateLibraryFilesPacket packet = new UpdateLibraryFilesPacket(this.publicFiles, privateFiles, setting);
            NetworkManager.sendTo(packet, player);
            ModLog.debug("syncing library files {}/{} to '{}'.", this.publicFiles.size(), privateFiles.size(), name);
        }

        public SkinLibrary getLibrary() {
            return this.skinLibrary;
        }

        @Override
        public boolean shouldDownloadFile(Player player) {
            if (!ModPermissions.SKIN_LIBRARY_SKIN_DOWNLOAD.accept(player)) {
                return false;
            }
            if (EnvironmentManager.isDedicatedServer()) {
                if (this.shouldMaintenanceFile(player)) {
                    return true;
                }
                return ModConfig.Common.allowDownloadingSkins;
            }
            return true;
        }

        @Override
        public boolean shouldUploadFile(Player player) {
            if (!ModPermissions.SKIN_LIBRARY_SKIN_UPLOAD.accept(player)) {
                return false;
            }
            if (EnvironmentManager.isDedicatedServer()) {
                if (this.shouldMaintenanceFile(player)) {
                    return true;
                }
                return ModConfig.Common.allowUploadingSkins;
            }
            return true;
        }

        @Override
        public boolean shouldMaintenanceFile(Player player) {
            if (ModConfig.Common.allowLibraryRemoteManage) {
                return player != null && player.m_20310_(5);
            }
            return false;
        }

        public int getVersion() {
            return this.version;
        }

        public String getPublicKey() {
            if (this.publicKey != null) {
                return this.publicKey;
            }
            String key = DataEncryptMethod.AUTH.key(this.getPrivateKey());
            this.publicKey = DataEncryptMethod.AUTH.signature(key);
            return this.publicKey;
        }

        public String getPrivateKey() {
            if (this.privateKey != null) {
                return this.privateKey;
            }
            UUID code = ModContext.t2(UUID.fromString("00000000-0000-0000-0000-000000000000"));
            this.privateKey = new OpenUUID(code.getMostSignificantBits(), code.getLeastSignificantBits()).toString();
            return this.privateKey;
        }

        public boolean isReady() {
            return this.isReady;
        }
    }
}

