/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.widget.ServerItemList;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.SearchColumnType;
import moe.plushie.armourers_workshop.library.data.impl.SearchOrderType;
import moe.plushie.armourers_workshop.library.data.impl.SearchResult;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SearchResultsLibraryPanel
extends AbstractLibraryPanel
implements GlobalSkinLibraryWindow.ISkinListListener {
    private final HashSet<Integer> downloadingPages = new HashSet();
    private final HashMap<Integer, ArrayList<ServerSkin>> downloadedPageList = new HashMap();
    private final UILabel resultTitle = new UILabel(CGRect.ZERO);
    private final ServerItemList skinPanelResults = new ServerItemList(CGRect.ZERO);
    private int itemSize = 48;
    private int lastRequestSize = 0;
    protected int currentPage = 0;
    protected int totalPages = -1;
    protected int totalResults = 0;
    private String keyword = "";
    private SkinType skinType = SkinTypes.UNKNOWN;
    private SearchColumnType columnType = SearchColumnType.DATE_CREATED;
    private SearchOrderType orderType = SearchOrderType.DESC;

    public SearchResultsLibraryPanel() {
        this("skin-library-global.searchResults", GlobalSkinLibraryWindow.Page.LIST_SEARCH::equals);
    }

    public SearchResultsLibraryPanel(String titleKey, Predicate<GlobalSkinLibraryWindow.Page> predicate) {
        super(titleKey, predicate);
        this.setup();
    }

    private void setup() {
        CGRect rect = this.bounds();
        this.resultTitle.setFrame(new CGRect(4.0f, 2.0f, rect.width - 64.0f, 16.0f));
        this.resultTitle.setTextColor(UIColor.WHITE);
        this.resultTitle.setAutoresizingMask(2);
        this.addSubview(this.resultTitle);
        this.skinPanelResults.setFrame(new CGRect(4.0f, 20.0f, rect.width - 8.0f, rect.height - 40.0f - 3.0f));
        this.skinPanelResults.setItemSelector(this::showSkinInfo);
        this.skinPanelResults.setAutoresizingMask(18);
        this.addSubview(this.skinPanelResults);
        this.setItemSize(this.itemSize);
        float iconX = rect.width - 4.0f;
        this.addIconButton(iconX - 52.0f, 2.0f, 16.0f, 16.0f, 48.0f, 0.0f, "small", this.buildItemSizeUpdater(32));
        this.addIconButton(iconX - 34.0f, 2.0f, 16.0f, 16.0f, 48.0f, 17.0f, "medium", this.buildItemSizeUpdater(48));
        this.addIconButton(iconX - 16.0f, 2.0f, 16.0f, 16.0f, 48.0f, 34.0f, "large", this.buildItemSizeUpdater(80));
        UIButton btn1 = this.addCommonButton(4.0f, rect.height - 20.0f, 16.0f, 16.0f, 208, 80, "common.button.previousPage", this.buildPageUpdater(-1));
        UIButton btn2 = this.addCommonButton(rect.width - 20.0f, rect.height - 20.0f, 16.0f, 16.0f, 208, 96, "common.button.nextPage", this.buildPageUpdater(1));
        btn1.setAutoresizingMask(12);
        btn2.setAutoresizingMask(9);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        int pageSize = this.skinPanelResults.getTotalCount();
        if (this.lastRequestSize > 0 && this.lastRequestSize != pageSize) {
            this.resize();
        } else {
            this.onPageDidChange();
        }
    }

    public void reloadData(String keyword, SkinType skinType, SearchColumnType columnType, SearchOrderType orderType) {
        this.clearResults();
        this.keyword = keyword;
        this.skinType = skinType;
        this.columnType = columnType;
        this.orderType = orderType;
        this.skinPanelResults.reloadData();
        this.fetchPage(0);
    }

    @Override
    public void skinDidChange(String skinId, @Nullable ServerSkin newValue) {
        if (newValue != null) {
            return;
        }
        Pair<Integer, Integer> page = this.getPageBySkin(skinId);
        if (page != null) {
            for (int key : this.downloadedPageList.keySet()) {
                if (key < (Integer)page.getKey()) continue;
                this.downloadedPageList.remove(key);
            }
            if (this.currentPage >= (Integer)page.getKey()) {
                this.fetchPage(this.currentPage);
                this.onPageDidChange();
            }
        }
    }

    protected void showSkinInfo(ServerSkin sender) {
        this.router.showSkinDetail(sender, GlobalSkinLibraryWindow.Page.LIST_SEARCH);
    }

    protected NSString getResultsTitle() {
        if (this.totalPages < 0) {
            return this.getDisplayText("label.searching", new Object[0]);
        }
        if (this.totalPages == 0) {
            return this.getDisplayText("label.no_results", new Object[0]);
        }
        return this.getDisplayText("results", this.currentPage + 1, this.totalPages, this.totalResults);
    }

    private void addIconButton(float x, float y, float width, float height, float u, float v, String key, BiConsumer<SearchResultsLibraryPanel, UIControl> handler) {
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setImage(ModTextures.iconImage(u, v, width, height, ModTextures.GLOBAL_SKIN_LIBRARY), 7);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.setTooltip(this.getDisplayText(key, new Object[0]));
        button.setAutoresizingMask(1);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, handler);
        this.addSubview(button);
    }

    private UIButton addCommonButton(float x, float y, float width, float height, int u, int v, String key, BiConsumer<SearchResultsLibraryPanel, UIControl> handler) {
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setImage(ModTextures.iconImage(u, v, width, height, ModTextures.BUTTONS), 7);
        button.setTooltip(NSString.localizedString(key, new Object[0]));
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, handler);
        this.addSubview(button);
        return button;
    }

    private void setItemSize(int itemSize) {
        this.itemSize = itemSize;
        this.skinPanelResults.setItemSize(new CGSize(itemSize, itemSize));
        this.skinPanelResults.setShowsName(itemSize >= 72);
        this.skinPanelResults.reloadData();
    }

    private BiConsumer<SearchResultsLibraryPanel, UIControl> buildPageUpdater(int step) {
        return (self, sender) -> {
            self.currentPage = OpenMath.clamp(self.currentPage + step, 0, self.totalPages - 1);
            this.fetchPage(self.currentPage);
            this.onPageDidChange();
            int pageIndex = self.currentPage + step;
            if (pageIndex > 0 && pageIndex < self.totalPages) {
                RenderSystem.recordRenderCall(() -> this.fetchPage(pageIndex));
            }
        };
    }

    private BiConsumer<SearchResultsLibraryPanel, UIControl> buildItemSizeUpdater(int size) {
        return (self, sender) -> {
            self.setItemSize(size);
            self.resize();
        };
    }

    protected void resize() {
        this.clearResults();
        this.fetchPage(this.currentPage);
    }

    public void clearResults() {
        this.downloadingPages.clear();
        this.downloadedPageList.clear();
        this.currentPage = 0;
        this.totalPages = -1;
        this.totalResults = 0;
        this.skinPanelResults.setEntries(new ArrayList());
        this.skinPanelResults.reloadData();
        this.lastRequestSize = 0;
        this.resultTitle.setText(this.getResultsTitle());
    }

    protected void fetchPage(int pageIndex) {
        if (this.downloadingPages.contains(pageIndex) || this.downloadedPageList.containsKey(pageIndex)) {
            return;
        }
        this.lastRequestSize = this.skinPanelResults.getTotalCount();
        this.downloadingPages.add(pageIndex);
        ModLog.debug("request skin list {} of {}, page size: {}", pageIndex, this.totalPages, this.lastRequestSize);
        this.doSearch(pageIndex, this.lastRequestSize, this.skinType, (result, exception) -> {
            if (exception != null) {
                exception.printStackTrace();
                this.downloadingPages.remove(pageIndex);
            } else {
                this.downloadingPages.remove(pageIndex);
                this.onPageJsonDownload(pageIndex, (SearchResult)result);
            }
        });
    }

    protected void doSearch(int pageIndex, int pageSize, SkinType searchType, IResultHandler<SearchResult> handler) {
        GlobalSkinLibrary.getInstance().searchSkin(this.keyword, pageIndex, pageSize, this.columnType, this.orderType, searchType, handler);
    }

    protected void onPageJsonDownload(int pageIndex, SearchResult result) {
        ArrayList<ServerSkin> entries = result.getSkins();
        this.totalPages = result.getTotalPages();
        this.totalResults = result.getTotalResults();
        this.downloadedPageList.put(pageIndex, entries);
        RenderSystem.recordRenderCall(() -> {
            ModLog.debug("receive skin list {} of {}", pageIndex, this.totalPages);
            this.onPageDidChange();
        });
        if (pageIndex == 0 && this.totalPages > 1) {
            RenderSystem.recordRenderCall(() -> this.fetchPage(1));
        }
    }

    private void onPageDidChange() {
        ArrayList entries = this.downloadedPageList.getOrDefault(this.currentPage, new ArrayList());
        this.skinPanelResults.setEntries(entries);
        this.skinPanelResults.reloadData();
        this.resultTitle.setText(this.getResultsTitle());
    }

    private Pair<Integer, Integer> getPageBySkin(String skinId) {
        for (Map.Entry<Integer, ArrayList<ServerSkin>> entry : this.downloadedPageList.entrySet()) {
            int index = Collections.indexOf((Iterable)entry.getValue(), e -> Objects.equals(e.getId(), skinId));
            if (index == -1) continue;
            return Pair.of((Object)entry.getKey(), (Object)index);
        }
        return null;
    }
}

