/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UILabelDelegate;
import java.util.Map;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.ServerStatus;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InfoLibraryPanel
extends AbstractLibraryPanel
implements UILabelDelegate {
    private static final String URL_DISCORD = "https://discord.gg/5Z3KKvU";
    private static final String URL_GITHUB = "https://github.com/Armourers-Workshop/Armourers-Workshop";
    private static final String URL_REDDIT = "https://www.reddit.com/r/ArmourersWorkshop/";
    private static final String URL_DONATION = "https://ko-fi.com/riskyken";
    private final UILabel label = new UILabel(CGRect.ZERO);
    private ServerStatus stats = null;
    private String failMessage = null;

    public InfoLibraryPanel() {
        super("skin-library-global.panel.info", GlobalSkinLibraryWindow.Page.LIBRARY_INFO::equals);
        this.setup();
    }

    private void setup() {
        this.label.setFrame(this.bounds().insetBy(5.0f, 5.0f, 5.0f, 5.0f));
        this.label.setAutoresizingMask(18);
        this.label.setTextVerticalAlignment(NSTextAlignment.Vertical.TOP);
        this.label.setNumberOfLines(0);
        this.label.setTextColor(UIColor.WHITE);
        this.label.setUserInteractionEnabled(true);
        this.label.setDelegate(this);
        this.addSubview(this.label);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.stats = null;
        this.failMessage = null;
        this.reloadUI();
        GlobalSkinLibrary.getInstance().getServerStatus((results, exception) -> {
            if (exception != null) {
                this.failMessage = exception.getMessage();
            } else {
                this.stats = results;
            }
            this.reloadUI();
        });
    }

    public void reloadUI() {
        NSMutableString message = new NSMutableString("\n\n\n");
        if (this.stats != null) {
            message.append(this.getDisplayText("total_skins", this.stats.getTotalSkin()));
            message.append("\n\n");
            message.append(this.getDisplayText("download_count", this.stats.getDownloadsLastHour(), this.stats.getDownloadsLastDay(), this.stats.getDownloadsLastWeek()));
            message.append("\n\n");
        } else if (this.failMessage != null) {
            message.append(this.getDisplayText("error_getting_stats", new Object[0]));
            message.append("\n\n");
            message.append(this.failMessage);
            message.append("\n\n");
        } else {
            message.append(this.getDisplayText("loading", new Object[0]));
            message.append("\n\n");
            message.append("\n\n");
        }
        message.append("\n");
        message.append(this.getDisplayText("links", new Object[0]));
        message.append("\n\n");
        message.append(this.getDisplayText("link.discord", new Object[0]));
        message.append(" ");
        message.append(this.getURLText(URL_DISCORD));
        message.append("\n\n");
        message.append(this.getDisplayText("link.github", new Object[0]));
        message.append(" ");
        message.append(this.getURLText(URL_GITHUB));
        message.append("\n\n");
        message.append(this.getDisplayText("link.reddit", new Object[0]));
        message.append(" ");
        message.append(this.getURLText(URL_REDDIT));
        message.append("\n\n");
        message.append("\n");
        message.append(this.getDisplayText("link.donation", new Object[0]));
        message.append(" ");
        message.append(this.getURLText(URL_DONATION));
        message.append("\n\n");
        this.label.setText(message);
    }

    @Override
    public void labelWillClickAttributes(UILabel label, Map<String, ?> attributes) {
        if (this.router != null) {
            this.router.labelWillClickAttributes(label, attributes);
        }
    }
}

